/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.auth;

import com.carepay.aws.auth.Credentials;
import com.carepay.aws.auth.CredentialsProvider;
import com.carepay.aws.auth.DefaultCredentialsProviderChain;
import com.carepay.aws.auth.RegionProvider;
import com.carepay.aws.net.MockHttpURLConnection;
import com.carepay.aws.net.QueryStringUtils;
import com.carepay.aws.net.URLOpener;
import com.carepay.aws.region.DefaultRegionProviderChain;
import com.carepay.aws.util.Hex;
import com.carepay.aws.util.SHA256;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class AWS4Signer {
    private static final String X_AMZ_DATE = "X-Amz-Date";
    private static final String X_AMZ_CONTENT_SHA_256 = "X-Amz-Content-SHA256";
    private static final String X_AMZ_ALGORITHM = "X-Amz-Algorithm";
    private static final String X_AMZ_CREDENTIAL = "X-Amz-Credential";
    private static final String X_AMZ_EXPIRES = "X-Amz-Expires";
    private static final String X_AMZ_SIGNED_HEADERS = "X-Amz-SignedHeaders";
    private static final String X_AMZ_SECURITY_TOKEN = "X-Amz-Security-Token";
    private static final String AWS_4_REQUEST = "aws4_request";
    private static final DateTimeFormatter AWS_DATE_FMT = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneOffset.UTC);
    private static final String AWS_4_HMAC_SHA_256 = "AWS4-HMAC-SHA256";
    protected static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    protected final Clock clock;
    protected final CredentialsProvider credentialsProvider;
    protected final RegionProvider regionProvider;
    private final Map<String, byte[]> keyCache = new WeakHashMap<String, byte[]>();
    private final String service;

    public AWS4Signer(String service) {
        this(service, DefaultCredentialsProviderChain.getInstance(), DefaultRegionProviderChain.getInstance(), Clock.systemUTC());
    }

    public AWS4Signer(String service, CredentialsProvider credentialsProvider, RegionProvider regionProvider, Clock clock) {
        this.service = service;
        this.credentialsProvider = credentialsProvider;
        this.regionProvider = regionProvider;
        this.clock = clock;
    }

    public boolean isSecurityTokenSigned() {
        return false;
    }

    public boolean isContentSha256Signed() {
        return false;
    }

    protected String calculateContentSha256(byte[] payload, int offset, int length) {
        return SHA256.hash(payload, offset, length);
    }

    public void signHeaders(HttpURLConnection httpURLConnection, byte[] payload) {
        this.signHeaders(httpURLConnection, payload, 0, payload != null ? payload.length : 0);
    }

    public void signHeaders(HttpURLConnection uc, byte[] payload, int offset, int length) {
        new SignRequest(uc).signHeaders(payload, offset, length);
    }

    public URL preSign(URL url) {
        return this.preSign(url, 604800);
    }

    public URL preSign(URL url, int expires) {
        return new SignRequest(url).signQuery(UNSIGNED_PAYLOAD, expires);
    }

    public RegionProvider getRegionProvider() {
        return this.regionProvider;
    }

    protected class SignRequest {
        private final URL url;
        private final HttpURLConnection urlConnection;
        private final TreeMap<String, String> signedHeaders;
        private final TreeMap<String, String> queryParams;
        private final String region;
        private final Credentials credentials;
        private final String dateTimeStr;
        private final String dateStr;
        private final String scope;

        public SignRequest(URL url) {
            this(new MockHttpURLConnection(url));
        }

        public SignRequest(HttpURLConnection urlConnection) {
            this.urlConnection = urlConnection;
            this.url = urlConnection.getURL();
            this.region = AWS4Signer.this.regionProvider.getRegion();
            this.credentials = Optional.ofNullable(AWS4Signer.this.credentialsProvider.getCredentials()).orElseThrow(() -> new IllegalStateException("No AWS credentials found"));
            this.dateTimeStr = AWS_DATE_FMT.format(AWS4Signer.this.clock.instant());
            this.dateStr = this.dateTimeStr.substring(0, 8);
            this.scope = String.join((CharSequence)"/", this.dateStr, this.region, AWS4Signer.this.service, AWS4Signer.AWS_4_REQUEST);
            this.signedHeaders = new TreeMap(String::compareToIgnoreCase);
            this.queryParams = new TreeMap<String, String>(QueryStringUtils.parseQueryString(this.url));
            this.signedHeaders.put("Host", QueryStringUtils.getHostname(this.url));
        }

        protected byte[] getSigningKey() {
            String cacheKey = AWS4Signer.this.service + this.region + this.credentials.getAccessKeyId() + this.dateStr;
            return AWS4Signer.this.keyCache.computeIfAbsent(cacheKey, key -> this.createSigningKey());
        }

        protected byte[] createSigningKey() {
            byte[] kSecret = this.getSecret();
            byte[] kDate = SHA256.sign(this.dateStr, kSecret);
            byte[] kRegion = SHA256.sign(this.region, kDate);
            byte[] kService = SHA256.sign(AWS4Signer.this.service, kRegion);
            return SHA256.sign(AWS4Signer.AWS_4_REQUEST, kService);
        }

        private byte[] getSecret() {
            return ("AWS4" + this.credentials.getSecretAccessKey()).getBytes(StandardCharsets.UTF_8);
        }

        public void signHeaders(byte[] payload, int offset, int length) {
            this.signedHeaders.put(AWS4Signer.X_AMZ_DATE, this.dateTimeStr);
            this.addOptionalSecurityToken();
            String contentSha256 = AWS4Signer.this.calculateContentSha256(payload, offset, length);
            if (AWS4Signer.this.isContentSha256Signed()) {
                this.signedHeaders.put(AWS4Signer.X_AMZ_CONTENT_SHA_256, contentSha256);
            }
            String stringToSign = this.getStringToSign(contentSha256);
            byte[] signature = SHA256.sign(stringToSign, this.getSigningKey());
            this.addAuthorizationHeader(signature);
        }

        protected void addOptionalSecurityToken() {
            String securityToken = this.credentials.getSessionToken();
            if (securityToken != null) {
                if (AWS4Signer.this.isSecurityTokenSigned()) {
                    this.signedHeaders.put(AWS4Signer.X_AMZ_SECURITY_TOKEN, securityToken);
                }
                this.urlConnection.setRequestProperty(AWS4Signer.X_AMZ_SECURITY_TOKEN, securityToken);
            }
        }

        private void addAuthorizationHeader(byte[] signature) {
            this.urlConnection.setRequestProperty("Authorization", "AWS4-HMAC-SHA256 Credential=" + this.credentials.getAccessKeyId() + '/' + this.scope + ", SignedHeaders=" + String.join((CharSequence)";", this.signedHeaders.keySet()).toLowerCase() + ", Signature=" + Hex.encode(signature));
        }

        protected String getStringToSign(String contentSha256) {
            StringBuilder canonicalStringBuilder = new StringBuilder(this.urlConnection.getRequestMethod()).append('\n').append(QueryStringUtils.uriEncodePath(this.url.getPath())).append('\n').append(QueryStringUtils.toQueryString(this.queryParams)).append('\n');
            this.signedHeaders.forEach((k, v) -> {
                canonicalStringBuilder.append(k.toLowerCase()).append(':').append((String)v).append('\n');
                this.urlConnection.setRequestProperty((String)k, (String)v);
            });
            canonicalStringBuilder.append('\n').append(String.join((CharSequence)";", this.signedHeaders.keySet()).toLowerCase()).append('\n').append(contentSha256);
            return String.join((CharSequence)"\n", AWS4Signer.AWS_4_HMAC_SHA_256, this.dateTimeStr, this.scope, SHA256.hash(canonicalStringBuilder.toString()));
        }

        public URL signQuery(String contentSha256, int expires) {
            StringBuilder result = new StringBuilder(this.url.getProtocol()).append("://").append(this.url.getAuthority()).append(this.url.getPath()).append('?');
            this.queryParams.put(AWS4Signer.X_AMZ_ALGORITHM, AWS4Signer.AWS_4_HMAC_SHA_256);
            this.queryParams.put(AWS4Signer.X_AMZ_CREDENTIAL, this.credentials.getAccessKeyId() + "/" + this.scope);
            this.queryParams.put(AWS4Signer.X_AMZ_DATE, this.dateTimeStr);
            this.queryParams.put(AWS4Signer.X_AMZ_EXPIRES, String.valueOf(expires));
            if (this.credentials.hasToken()) {
                this.queryParams.put(AWS4Signer.X_AMZ_SECURITY_TOKEN, this.credentials.getSessionToken());
            }
            this.queryParams.put(AWS4Signer.X_AMZ_SIGNED_HEADERS, String.join((CharSequence)";", this.signedHeaders.keySet()).toLowerCase());
            result.append(QueryStringUtils.toQueryString(this.queryParams));
            String stringToSign = this.getStringToSign(contentSha256);
            byte[] signature = SHA256.sign(stringToSign, this.getSigningKey());
            result.append("&X-Amz-Signature=").append(Hex.encode(signature));
            return URLOpener.create(result.toString());
        }
    }
}

