/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.auth;

import java.time.Instant;
import java.time.format.DateTimeFormatter;

public class Credentials {
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final Instant expiration;

    public Credentials() {
        this(null, null, null, (Instant)null);
    }

    public Credentials(String accessKeyId, String secretAccessKey, String sessionToken) {
        this(accessKeyId, secretAccessKey, sessionToken, (Instant)null);
    }

    public Credentials(String accessKeyId, String secretAccessKey, String sessionToken, String expiration) {
        this(accessKeyId, secretAccessKey, sessionToken, expiration != null ? DateTimeFormatter.ISO_INSTANT.parse((CharSequence)expiration, Instant::from) : null);
    }

    public Credentials(String accessKeyId, String secretAccessKey, String sessionToken, Instant expiration) {
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.expiration = expiration;
    }

    public boolean isPresent() {
        return this.accessKeyId != null && this.secretAccessKey != null;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public boolean hasToken() {
        return this.sessionToken != null;
    }
}

