/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.auth;

import com.carepay.aws.auth.Credentials;
import com.carepay.aws.auth.CredentialsProvider;
import com.carepay.aws.auth.EC2CredentialsProvider;
import com.carepay.aws.auth.EnvironmentCredentialsProvider;
import com.carepay.aws.auth.ProfileCredentialsProvider;
import com.carepay.aws.auth.SystemPropertyCredentialsProvider;
import com.carepay.aws.auth.WebIdentityTokenCredentialsProvider;
import java.time.Clock;

public class DefaultCredentialsProviderChain
implements CredentialsProvider {
    private static final CredentialsProvider INSTANCE = new DefaultCredentialsProviderChain();
    private final CredentialsProvider[] providers;
    private final Clock clock;
    private Credentials cachedCredentials;

    public DefaultCredentialsProviderChain() {
        this(Clock.systemUTC(), new EnvironmentCredentialsProvider(), new SystemPropertyCredentialsProvider(), new WebIdentityTokenCredentialsProvider(), new ProfileCredentialsProvider(), new EC2CredentialsProvider());
    }

    public DefaultCredentialsProviderChain(Clock clock, CredentialsProvider ... providers) {
        this.clock = clock;
        this.providers = providers;
    }

    public static CredentialsProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public Credentials getCredentials() {
        if (this.cachedCredentials != null && (this.cachedCredentials.getExpiration() == null || this.cachedCredentials.getExpiration().isAfter(this.clock.instant()))) {
            return this.cachedCredentials;
        }
        for (CredentialsProvider provider : this.providers) {
            Credentials credentials = provider.getCredentials();
            if (credentials == null || !credentials.isPresent()) continue;
            this.cachedCredentials = credentials;
            return credentials;
        }
        return null;
    }
}

