/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.auth;

import com.carepay.aws.auth.Credentials;
import com.carepay.aws.auth.CredentialsProvider;
import com.carepay.aws.auth.EC2Credentials;
import com.carepay.aws.net.FirstLineResponseReader;
import com.carepay.aws.net.JsonResponseReader;
import com.carepay.aws.net.URLOpener;
import com.carepay.aws.net.WebClient;
import com.carepay.aws.util.Env;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class EC2CredentialsProvider
implements CredentialsProvider {
    static final String ECS_CONTAINER_CREDENTIALS_PATH = "AWS_CONTAINER_CREDENTIALS_RELATIVE_URI";
    static final String CONTAINER_CREDENTIALS_FULL_URI = "AWS_CONTAINER_CREDENTIALS_FULL_URI";
    static final String CONTAINER_AUTHORIZATION_TOKEN = "AWS_CONTAINER_AUTHORIZATION_TOKEN";
    private static final String ECS_CREDENTIALS_ENDPOINT = "http://169.254.170.2";
    static final String SECURITY_CREDENTIALS_URL = "http://169.254.169.254/latest/meta-data/iam/security-credentials/";
    private final WebClient webClient;
    final URL url;
    final Map<String, String> headers = new HashMap<String, String>();
    private static final JsonResponseReader<EC2Credentials> JSON_RESPONSE_READER = new JsonResponseReader<EC2Credentials>(EC2Credentials.class);

    public EC2CredentialsProvider() {
        this(new WebClient(new URLOpener.Default()), new Env.Default());
    }

    public EC2CredentialsProvider(WebClient webClient, Env env) {
        this.webClient = webClient;
        URL credentialsUrl = null;
        try {
            String relativeUri = env.getEnv(ECS_CONTAINER_CREDENTIALS_PATH);
            if (relativeUri != null) {
                credentialsUrl = new URL(ECS_CREDENTIALS_ENDPOINT + relativeUri);
            } else {
                String fullUri = env.getEnv(CONTAINER_CREDENTIALS_FULL_URI);
                if (fullUri != null) {
                    credentialsUrl = new URL(fullUri);
                    String token = env.getEnv(CONTAINER_AUTHORIZATION_TOKEN);
                    if (token != null) {
                        this.headers.put("Authorization", token);
                    }
                } else {
                    URL securityCredentialsUrl = new URL(SECURITY_CREDENTIALS_URL);
                    String role = webClient.execute("GET", securityCredentialsUrl, null, new FirstLineResponseReader(), null);
                    if (role != null) {
                        credentialsUrl = new URL(securityCredentialsUrl, role);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.url = credentialsUrl;
    }

    @Override
    public Credentials getCredentials() {
        if (this.url != null) {
            try {
                EC2Credentials ec2Credentials = this.webClient.execute("GET", this.url, null, JSON_RESPONSE_READER, this.headers);
                return ec2Credentials;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

