/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.auth;

import com.carepay.aws.auth.Credentials;
import com.carepay.aws.auth.CredentialsProvider;
import com.carepay.aws.util.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;

public class ProcessCredentialsProvider
implements CredentialsProvider {
    static final String CREDENTIAL_PROCESS = "credential_process";
    private final Map<String, String> section;
    private final JsonParser parser = new JsonParser();

    public ProcessCredentialsProvider(Map<String, String> section) {
        this.section = section;
    }

    @Override
    public Credentials getCredentials() {
        ProcessBuilder processBuilder = this.setupCommand();
        try {
            return this.executeCommand(processBuilder);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    protected ProcessBuilder setupCommand() {
        String credentialsProcess = this.section.get(CREDENTIAL_PROCESS);
        ArrayList<String> cmd = new ArrayList<String>();
        String osName = System.getProperty("os.name");
        if (osName != null && osName.startsWith("Windows")) {
            cmd.add("cmd.exe");
            cmd.add("/C");
        } else {
            cmd.add("sh");
            cmd.add("-c");
        }
        cmd.add(credentialsProcess);
        return new ProcessBuilder(cmd);
    }

    protected Credentials executeCommand(ProcessBuilder processBuilder) throws IOException {
        Process process = processBuilder.start();
        try {
            Credentials credentials;
            block13: {
                InputStream input = process.getInputStream();
                try {
                    process.waitFor();
                    if (process.exitValue() != 0) {
                        throw new IllegalStateException("Command returned non-zero exit value: " + process.exitValue());
                    }
                    credentials = (Credentials)this.parser.parse(input, Credentials.class);
                    if (input == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e.getMessage(), e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                }
                input.close();
            }
            return credentials;
        }
        finally {
            process.destroy();
        }
    }
}

