/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.auth;

import com.carepay.aws.auth.Credentials;
import com.carepay.aws.auth.CredentialsProvider;
import com.carepay.aws.auth.ProcessCredentialsProvider;
import com.carepay.aws.auth.SingleSignOnCredentialsProvider;
import com.carepay.aws.auth.StaticProfileCredentialsProvider;
import com.carepay.aws.net.URLOpener;
import com.carepay.aws.util.Env;
import com.carepay.aws.util.IniFile;
import java.io.File;
import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class ProfileCredentialsProvider
implements CredentialsProvider {
    private static final String USER_HOME = "user.home";
    private static final String AWS_CONFIG_FILENAME = ".aws/config";
    private static final String AWS_PROFILE = "AWS_PROFILE";
    private static final String DEFAULT = "default";
    private final File file;
    private final Env env;
    private final Clock clock;
    private final URLOpener opener;

    public ProfileCredentialsProvider() {
        this(new File(new File(System.getProperty(USER_HOME)), AWS_CONFIG_FILENAME), new Env.Default(), Clock.systemUTC(), new URLOpener.Default());
    }

    public ProfileCredentialsProvider(File file, Env env, Clock clock, URLOpener opener) {
        this.file = file;
        this.env = env;
        this.clock = clock;
        this.opener = opener;
    }

    @Override
    public Credentials getCredentials() {
        String profileName = Optional.ofNullable(this.env.getEnv(AWS_PROFILE)).orElseGet(() -> Optional.ofNullable(System.getProperty("aws.profile")).orElse(DEFAULT));
        Map<String, String> section = this.getIniFileSection(profileName);
        return this.getDelegateCredentialsProvider(profileName, section).getCredentials();
    }

    private Map<String, String> getIniFileSection(String profileName) {
        IniFile iniFile = new IniFile(this.file);
        return Optional.ofNullable(iniFile.getSection(profileName)).orElseGet(() -> Optional.ofNullable(iniFile.getSection(DEFAULT)).orElse(Collections.emptyMap()));
    }

    private CredentialsProvider getDelegateCredentialsProvider(String profileName, Map<String, String> section) {
        if (section.containsKey("sso_start_url")) {
            return new SingleSignOnCredentialsProvider(this.file.getParentFile(), section, this.clock, this.opener);
        }
        if (section.containsKey("credential_process")) {
            return new ProcessCredentialsProvider(section);
        }
        return new StaticProfileCredentialsProvider(new File(this.file.getParentFile(), "credentials"), profileName);
    }
}

