/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.auth;

import com.carepay.aws.auth.Credentials;
import com.carepay.aws.auth.CredentialsProvider;
import com.carepay.aws.net.URLOpener;
import com.carepay.aws.util.Hex;
import com.carepay.aws.util.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;

public class SingleSignOnCredentialsProvider
implements CredentialsProvider {
    static final String SSO_START_URL = "sso_start_url";
    static final String SSO_REGION = "sso_region";
    static final String SSO_ACCOUNT_ID = "sso_account_id";
    static final String SSO_ROLE_NAME = "sso_role_name";
    final File cacheFile;
    final URL url;
    private final Clock clock;
    private final URLOpener opener;
    private final JsonParser parser = new JsonParser();

    public SingleSignOnCredentialsProvider(File awsDir, Map<String, String> section, Clock clock, URLOpener opener) {
        String ssoStartUrl = section.get(SSO_START_URL);
        String region = section.get(SSO_REGION);
        String accountId = section.get(SSO_ACCOUNT_ID);
        String roleName = section.get(SSO_ROLE_NAME);
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            if (ssoStartUrl != null) {
                this.cacheFile = new File(awsDir, "sso/cache/" + Hex.encode(sha1.digest(ssoStartUrl.getBytes(StandardCharsets.UTF_8))) + ".json");
                this.url = URLOpener.create("https://portal.sso." + region + ".amazonaws.com/federation/credentials?role_name=" + roleName + "&account_id=" + accountId);
            } else {
                this.cacheFile = null;
                this.url = null;
            }
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.clock = clock;
        this.opener = opener;
    }

    @Override
    public Credentials getCredentials() {
        if (this.cacheFile != null && this.cacheFile.exists()) {
            Credentials credentials;
            block11: {
                CachedCredentials cachedCredentials = (CachedCredentials)this.parser.parse(new FileInputStream(this.cacheFile), CachedCredentials.class);
                if (cachedCredentials.expiresAt.isBefore(this.clock.instant())) {
                    return null;
                }
                HttpURLConnection uc = this.opener.open(this.url);
                uc.setRequestProperty("x-amz-sso_bearer_token", cachedCredentials.accessToken);
                if (uc.getResponseCode() != 200) {
                    return null;
                }
                InputStream in = uc.getInputStream();
                try {
                    RoleCredentials roleCredentials = (RoleCredentials)this.parser.parse(in, RoleCredentials.class);
                    credentials = roleCredentials.roleCredentials;
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                in.close();
            }
            return credentials;
        }
        return null;
    }

    public static class RoleCredentials {
        private Credentials roleCredentials;
    }

    public static class CachedCredentials {
        private String accessToken;
        private Instant expiresAt;
    }
}

