/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.auth;

import com.carepay.aws.auth.Credentials;
import com.carepay.aws.auth.CredentialsProvider;
import com.carepay.aws.util.IniFile;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class StaticProfileCredentialsProvider
implements CredentialsProvider {
    private static final String AWS_ACCESS_KEY_ID = "aws_access_key_id";
    private static final String AWS_SECRET_ACCESS_KEY = "aws_secret_access_key";
    private static final String AWS_SESSION_TOKEN = "aws_session_token";
    private final File credentialsFile;
    private final String profileName;

    public StaticProfileCredentialsProvider(File credentialsFile, String profileName) {
        this.credentialsFile = credentialsFile;
        this.profileName = profileName;
    }

    @Override
    public Credentials getCredentials() {
        IniFile iniFile = new IniFile(this.credentialsFile);
        Map section = Optional.ofNullable(iniFile.getSection(this.profileName)).orElseGet(() -> Optional.ofNullable(iniFile.getSection("default")).orElse(Collections.emptyMap()));
        String accessKeyId = (String)section.get(AWS_ACCESS_KEY_ID);
        String secretAccessKey = (String)section.get(AWS_SECRET_ACCESS_KEY);
        return accessKeyId != null && secretAccessKey != null ? new Credentials(accessKeyId, secretAccessKey, (String)section.get(AWS_SESSION_TOKEN)) : null;
    }
}

