/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.ec2;

import com.carepay.aws.AWSClient;
import com.carepay.aws.auth.AWS4Signer;
import com.carepay.aws.ec2.DescribeTagsResponse;
import com.carepay.aws.ec2.EC2MetaData;
import com.carepay.aws.ec2.Error;
import com.carepay.aws.ec2.ErrorResponse;
import com.carepay.aws.ec2.Tag;
import com.carepay.aws.net.FormUrlEncodedRequestWriter;
import com.carepay.aws.net.URLOpener;
import com.carepay.aws.net.XmlResponseReader;
import com.carepay.aws.util.JsonParser;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class EC2
extends AWSClient {
    public static final URL META_DATA_URL = URLOpener.create("http://169.254.169.254/latest/dynamic/instance-identity/document");
    private JsonParser parser = new JsonParser();

    public EC2() {
        this(new AWS4Signer("ec2"), new URLOpener.Default());
    }

    public EC2(AWS4Signer signer, URLOpener opener) {
        super(signer, opener);
    }

    public Map<String, String> describeTags(String instanceId) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Action", "DescribeTags");
        params.put("Version", "2016-11-15");
        params.put("Filter.1.Name", "resource-id");
        params.put("Filter.1.Value.1", instanceId);
        URL url = new URL("https://ec2." + this.getRegion() + ".amazonaws.com/");
        DescribeTagsResponse response = super.signedExecute("POST", url, new FormUrlEncodedRequestWriter(params), new XmlResponseReader<DescribeTagsResponse>(DescribeTagsResponse.class), null);
        return response.getTagSet().stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue));
    }

    public EC2MetaData queryMetaData() throws IOException {
        return super.execute("GET", META_DATA_URL, null, uc -> (EC2MetaData)this.parser.parse(uc.getInputStream(), EC2MetaData.class), null);
    }

    @Override
    protected void handleFailedResponse(HttpURLConnection uc) throws IOException {
        XmlResponseReader<ErrorResponse> reader = new XmlResponseReader<ErrorResponse>(ErrorResponse.class);
        ErrorResponse errorResponse = reader.read(uc);
        String message = errorResponse.getErrors().stream().findFirst().map(Error::getMessage).orElse(uc.getResponseMessage());
        throw new IOException(message);
    }
}

