/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.net;

import com.carepay.aws.net.FormUrlEncodedUtils;
import com.carepay.aws.net.RequestWriter;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class FormUrlEncodedRequestWriter
implements RequestWriter {
    private final Map<String, String> parameters;

    public FormUrlEncodedRequestWriter(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void write(HttpURLConnection os) throws IOException {
        os.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        byte[] bytes = FormUrlEncodedUtils.encode(this.parameters).getBytes(StandardCharsets.UTF_8);
        os.setFixedLengthStreamingMode(bytes.length);
        os.getOutputStream().write(bytes);
    }
}

