/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.net;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;

public final class QueryStringUtils {
    private static final char[] HEX_DIGITS_UPPER = "0123456789ABCDEF".toCharArray();
    private static final char[] HEX_TO_CHAR = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0000'};
    private static final BitSet ENCODING_NOT_NEEDED = new BitSet(256);
    private static final BitSet ENCODING_NOT_NEEDED_PATH = new BitSet(256);

    private QueryStringUtils() {
        throw new IllegalStateException();
    }

    public static String toQueryString(Map<String, String> map) {
        return map.entrySet().stream().map(e -> QueryStringUtils.uriEncode((String)e.getKey()) + "=" + QueryStringUtils.uriEncode((String)e.getValue())).collect(Collectors.joining("&"));
    }

    public static String toQueryPathString(Map<String, String> map) {
        return map.entrySet().stream().map(e -> QueryStringUtils.uriEncodePath((String)e.getKey()) + "=" + QueryStringUtils.uriEncodePath((String)e.getValue())).collect(Collectors.joining("&"));
    }

    public static Map<String, String> parseQueryString(URL url) {
        String queryString = url.getQuery();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (QueryStringUtils.isNotEmpty(queryString)) {
            for (String pair : queryString.split("&", -1)) {
                int idx = pair.indexOf("=");
                queryParams.put(QueryStringUtils.uriDecode(pair.substring(0, idx)), QueryStringUtils.uriDecode(pair.substring(idx + 1)));
            }
        }
        return queryParams;
    }

    private static boolean isNotEmpty(String queryString) {
        return queryString != null && !queryString.isEmpty();
    }

    public static String uriEncode(String input) {
        StringBuilder result = new StringBuilder();
        for (byte singleByte : input.getBytes(StandardCharsets.UTF_8)) {
            char ch = (char)singleByte;
            if (ENCODING_NOT_NEEDED.get(ch)) {
                result.append(ch);
                continue;
            }
            QueryStringUtils.appendEncoded(result, ch);
        }
        return result.toString();
    }

    private static void appendEncoded(StringBuilder result, char ch) {
        result.append('%').append(HEX_DIGITS_UPPER[ch >> 4 & 0xF]).append(HEX_DIGITS_UPPER[ch & 0xF]);
    }

    public static String uriEncodePath(String input) {
        byte[] bytes;
        StringBuilder result = new StringBuilder();
        for (byte singleByte : bytes = input.getBytes(StandardCharsets.UTF_8)) {
            char ch = (char)singleByte;
            if (ENCODING_NOT_NEEDED_PATH.get(ch)) {
                result.append(ch);
                continue;
            }
            QueryStringUtils.appendEncoded(result, ch);
        }
        return result.toString();
    }

    public static String uriDecode(String input) {
        byte[] bytes = new byte[input.length()];
        PrimitiveIterator.OfInt iter = input.chars().iterator();
        int j = 0;
        while (iter.hasNext()) {
            int ch = iter.nextInt();
            if (ch == 37) {
                ch = QueryStringUtils.uriDecodeChar(iter);
            }
            bytes[j++] = (byte)ch;
        }
        return new String(bytes, 0, j, StandardCharsets.UTF_8);
    }

    protected static char uriDecodeChar(PrimitiveIterator.OfInt iter) {
        return (char)(HEX_TO_CHAR[iter.next()] << 4 | HEX_TO_CHAR[iter.next()]);
    }

    public static String getHostname(URL url) {
        if (QueryStringUtils.hasCustomPort(url)) {
            return url.getHost() + ":" + url.getPort();
        }
        return url.getHost();
    }

    public static boolean hasCustomPort(URL url) {
        return url.getPort() > 0;
    }

    static {
        ENCODING_NOT_NEEDED.set(97, 123);
        ENCODING_NOT_NEEDED.set(65, 91);
        ENCODING_NOT_NEEDED.set(48, 58);
        ENCODING_NOT_NEEDED.set(126);
        ENCODING_NOT_NEEDED.set(45);
        ENCODING_NOT_NEEDED.set(95);
        ENCODING_NOT_NEEDED.set(46);
        ENCODING_NOT_NEEDED_PATH.or(ENCODING_NOT_NEEDED);
        ENCODING_NOT_NEEDED_PATH.set(47);
    }
}

