/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.net;

import com.carepay.aws.net.RequestWriter;
import com.carepay.aws.net.ResponseReader;
import com.carepay.aws.net.URLOpener;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class WebClient {
    protected final URLOpener opener;

    public WebClient() {
        this(new URLOpener.Default());
    }

    public WebClient(URLOpener opener) {
        this.opener = opener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(String method, URL url, RequestWriter requestWriter, ResponseReader<T> responseConverter, Map<String, String> headers) throws IOException {
        HttpURLConnection uc = this.opener.open(url);
        try {
            uc.setDoOutput(requestWriter != null);
            uc.setRequestMethod(method);
            uc.setConnectTimeout(1000);
            uc.setReadTimeout(1000);
            if (headers != null) {
                headers.forEach(uc::setRequestProperty);
            }
            if (requestWriter != null) {
                requestWriter.write(uc);
            }
            this.assertResponseCode(uc);
            T t = responseConverter != null ? (T)responseConverter.read(uc) : null;
            return t;
        }
        finally {
            uc.disconnect();
        }
    }

    protected void assertResponseCode(HttpURLConnection uc) throws IOException {
        if (this.hasFailed(uc)) {
            this.handleFailedResponse(uc);
        }
    }

    protected void handleFailedResponse(HttpURLConnection uc) throws IOException {
        throw new IOException(uc.getResponseMessage());
    }

    protected boolean hasFailed(HttpURLConnection uc) throws IOException {
        return uc.getResponseCode() >= 400;
    }
}

