/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.region;

import com.carepay.aws.auth.RegionProvider;
import com.carepay.aws.ec2.EC2RegionProvider;
import com.carepay.aws.region.EnvironmentRegionProvider;
import com.carepay.aws.region.ProfileRegionProvider;
import com.carepay.aws.region.SystemPropertyRegionProvider;

public class DefaultRegionProviderChain
implements RegionProvider {
    private static final RegionProvider INSTANCE = new DefaultRegionProviderChain();
    private final RegionProvider[] providers;
    private String region;

    public DefaultRegionProviderChain() {
        this(new EnvironmentRegionProvider(), new SystemPropertyRegionProvider(), new ProfileRegionProvider(), new EC2RegionProvider());
    }

    public DefaultRegionProviderChain(RegionProvider ... providers) {
        this.providers = providers;
    }

    public static RegionProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public String getRegion() {
        if (this.region == null) {
            for (RegionProvider provider : this.providers) {
                this.region = provider.getRegion();
                if (this.region != null) break;
            }
        }
        return this.region;
    }
}

