/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.region;

import com.carepay.aws.auth.RegionProvider;
import com.carepay.aws.util.Env;
import com.carepay.aws.util.IniFile;
import java.io.File;
import java.util.Map;
import java.util.Optional;

public class ProfileRegionProvider
implements RegionProvider {
    private static final String USER_HOME = "user.home";
    private static final String AWS_CONFIG = ".aws/config";
    private static final String AWS_PROFILE = "AWS_PROFILE";
    private static final String DEFAULT = "default";
    private static final String REGION = "region";
    private final File file;
    private final Env env;

    public ProfileRegionProvider() {
        this(new File(new File(System.getProperty(USER_HOME)), AWS_CONFIG), new Env.Default());
    }

    public ProfileRegionProvider(File file, Env env) {
        this.file = file;
        this.env = env;
    }

    @Override
    public String getRegion() {
        IniFile profileFile = new IniFile(this.file);
        String profileName = Optional.ofNullable(this.env.getEnv(AWS_PROFILE)).orElseGet(() -> Optional.ofNullable(System.getProperty("aws.profile")).orElse(DEFAULT));
        Map section = Optional.ofNullable(profileFile.getSection(profileName)).orElseGet(() -> profileFile.getSection(DEFAULT));
        return section != null ? (String)section.get(REGION) : null;
    }
}

