/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.s3;

import com.carepay.aws.AWSClient;
import com.carepay.aws.auth.AWS4Signer;
import com.carepay.aws.net.ResponseReader;
import com.carepay.aws.net.URLOpener;
import com.carepay.aws.net.XmlResponseReader;
import com.carepay.aws.s3.ErrorResponse;
import com.carepay.aws.s3.InitiateMultipartUploadResult;
import com.carepay.aws.s3.S3AWS4Signer;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class S3
extends AWSClient {
    private static final String AMAZONAWS_COM = "amazonaws.com";
    private static final String HTTPS = "https";
    private static final String SERVICE_S3 = "s3";
    private final Map<String, Multipart> multiparts = new HashMap<String, Multipart>();

    public S3() {
        this(new S3AWS4Signer(), new URLOpener.Default());
    }

    public S3(AWS4Signer signer, URLOpener opener) {
        super(signer, opener);
    }

    public String startMultipart(String bucket, String path) throws IOException {
        URL url = this.getUrl(bucket, path + "?uploads");
        InitiateMultipartUploadResult result = super.signedExecute("POST", url, null, new XmlResponseReader<InitiateMultipartUploadResult>(InitiateMultipartUploadResult.class), null);
        this.multiparts.put(result.getUploadId(), new Multipart(bucket, path));
        this.expireMultipartUploads();
        return result.getUploadId();
    }

    public void uploadPart(String uploadId, byte[] buf, int offset, int length) throws IOException {
        Multipart multipart = this.getMultipart(uploadId);
        int partNumber = multipart.parts.size() + 1;
        URL url = this.getUrl(multipart.bucket, multipart.key + "?PartNumber=" + partNumber + "&UploadId=" + uploadId);
        String etag = super.signedExecute("PUT", url, uc -> uc.getOutputStream().write(buf, offset, length), new ETagHeaderResponseReader(), new HashMap<String, String>());
        multipart.parts.add(new PartETag(partNumber, etag));
    }

    protected Multipart getMultipart(String uploadId) {
        this.expireMultipartUploads();
        return Optional.ofNullable(this.multiparts.get(uploadId)).orElseThrow(() -> new IllegalArgumentException(uploadId));
    }

    public void finishMultipart(String uploadId) throws IOException {
        Multipart multipart = this.getMultipart(uploadId);
        URL url = this.getUrl(multipart.bucket, multipart.key + "?UploadId=" + uploadId);
        StringBuilder sb = new StringBuilder("<CompleteMultipartUpload xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">");
        for (PartETag part : multipart.parts) {
            sb.append("<Part><ETag>").append(part.etag).append("</ETag><PartNumber>").append(part.partNumber).append("</PartNumber></Part>");
        }
        sb.append("</CompleteMultipartUpload>");
        byte[] payload = sb.toString().getBytes(StandardCharsets.UTF_8);
        super.signedExecute("POST", url, uc -> uc.getOutputStream().write(payload), null, null);
        this.multiparts.remove(uploadId);
    }

    public void putObject(String bucket, String path, byte[] buf, int offset, int length) throws IOException {
        URL url = this.getUrl(bucket, path);
        super.signedExecute("PUT", url, uc -> uc.getOutputStream().write(buf, offset, length), null, null);
    }

    private URL getUrl(String bucket, String path) throws MalformedURLException {
        return new URL("https://" + bucket + ".s3.amazonaws.com" + path);
    }

    public void abortMultipartUpload(String uploadId) throws IOException {
        Multipart multipart = this.getMultipart(uploadId);
        URL url = this.getUrl(multipart.bucket, multipart.key + "?UploadId=" + uploadId);
        super.signedExecute("DELETE", url, null, null, null);
        this.multiparts.remove(uploadId);
    }

    @Override
    protected void handleFailedResponse(HttpURLConnection uc) throws IOException {
        XmlResponseReader<ErrorResponse> reader = new XmlResponseReader<ErrorResponse>(ErrorResponse.class);
        ErrorResponse errorResponse = reader.read(uc);
        throw new IOException(errorResponse.getMessage());
    }

    protected void expireMultipartUploads() {
        long expirationTime = this.getExpirationTime();
        this.multiparts.entrySet().removeIf(entry -> ((Multipart)entry.getValue()).timestamp < expirationTime);
    }

    private long getExpirationTime() {
        return System.nanoTime() - TimeUnit.NANOSECONDS.convert(1L, TimeUnit.HOURS);
    }

    static class ETagHeaderResponseReader
    implements ResponseReader<String> {
        ETagHeaderResponseReader() {
        }

        @Override
        public String read(HttpURLConnection uc) throws IOException {
            return uc.getHeaderField("ETag");
        }
    }

    static class PartETag {
        private final int partNumber;
        private final String etag;

        public PartETag(int partNumber, String etag) {
            this.partNumber = partNumber;
            this.etag = etag;
        }
    }

    private static class Multipart {
        private final String bucket;
        private final String key;
        private final List<PartETag> parts;
        private final long timestamp;

        private Multipart(String bucket, String key) {
            this.bucket = bucket;
            this.key = key;
            this.parts = new ArrayList<PartETag>();
            this.timestamp = System.nanoTime();
        }
    }
}

