/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.s3;

import com.carepay.aws.s3.S3;
import java.io.IOException;
import java.io.OutputStream;

public class S3OutputStream
extends OutputStream {
    public static final int BUFFER_SIZE = 0x1000000;
    private final String bucket;
    private final String path;
    private final byte[] buf;
    private final S3 s3;
    private int position;
    private String uploadId;
    private boolean open;

    public S3OutputStream(S3 s3, String bucket, String path) {
        this.s3 = s3;
        this.bucket = bucket;
        this.path = path;
        this.buf = new byte[0x1000000];
        this.position = 0;
        this.open = true;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] byteArray, int offset, int length) throws IOException {
        int len;
        int size;
        this.assertOpen();
        int ofs = offset;
        for (len = length; len > (size = this.buf.length - this.position); len -= size) {
            System.arraycopy(byteArray, ofs, this.buf, this.position, size);
            this.position += size;
            this.flushBufferAndRewind();
            ofs += size;
        }
        System.arraycopy(byteArray, ofs, this.buf, this.position, len);
        this.position += len;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.assertOpen();
        this.flushBufferAndRewind();
    }

    protected void flushBufferAndRewind() throws IOException {
        if (this.uploadId == null) {
            this.uploadId = this.s3.startMultipart(this.bucket, this.path);
        }
        this.uploadPart();
        this.position = 0;
    }

    protected void uploadPart() throws IOException {
        this.s3.uploadPart(this.uploadId, this.buf, 0, this.position);
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.open = false;
            if (this.uploadId != null) {
                if (this.position > 0) {
                    this.uploadPart();
                }
                this.s3.finishMultipart(this.uploadId);
            } else {
                this.s3.putObject(this.bucket, this.path, this.buf, 0, this.position);
            }
        }
    }

    public void cancel() throws IOException {
        this.open = false;
        if (this.uploadId != null) {
            this.s3.abortMultipartUpload(this.uploadId);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.assertOpen();
        if (this.position >= this.buf.length) {
            this.flushBufferAndRewind();
        }
        this.buf[this.position++] = (byte)b;
    }

    private void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("Closed");
        }
    }
}

