/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BeanSAXContentHandler
extends DefaultHandler {
    private static final Field NO_SUCH_FIELD;
    private static final Object NO_SUCH_OBJECT;
    boolean rootElementFound;
    private final Deque<Object> stack = new ArrayDeque<Object>();
    private Field field;
    private final StringBuilder value = new StringBuilder();

    public BeanSAXContentHandler(Object obj) {
        this.stack.push(obj);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (!this.rootElementFound) {
                this.rootElementFound = true;
                return;
            }
            if (this.field != null) {
                Object child = this.field.getType().newInstance();
                if (this.field != NO_SUCH_FIELD) {
                    this.field.set(this.stack.peek(), child);
                }
                this.stack.push(child);
            } else if (this.stack.peek() instanceof CollectionWrapper) {
                this.stack.push(((CollectionWrapper)this.stack.peek()).add());
                return;
            }
            this.findField(Character.toLowerCase(qName.charAt(0)) + qName.substring(1));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SAXException(e);
        }
    }

    private void findField(String fieldName) {
        Class<?> clazz = this.stack.peek().getClass();
        while (true) {
            try {
                this.field = clazz.getDeclaredField(fieldName);
                this.field.setAccessible(true);
                if (Collection.class.isAssignableFrom(this.field.getType())) {
                    Collection collection = (Collection)this.field.getType().newInstance();
                    this.field.set(this.stack.peek(), collection);
                    this.stack.push(new CollectionWrapper(collection, (Class)((ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[0]));
                    this.field = null;
                }
                return;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                this.field = NO_SUCH_FIELD;
                return;
            }
            break;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.field != null) {
            String trimmedValue = this.value.toString().trim();
            if (this.field != NO_SUCH_FIELD && !trimmedValue.isEmpty()) {
                try {
                    if (this.field.getType().isAssignableFrom(String.class)) {
                        this.field.set(this.stack.peek(), trimmedValue);
                    }
                    if (this.field.getType().isAssignableFrom(Integer.class)) {
                        this.field.set(this.stack.peek(), Integer.valueOf(trimmedValue));
                    }
                    if (this.field.getType().isAssignableFrom(Instant.class)) {
                        this.field.set(this.stack.peek(), Instant.parse(trimmedValue));
                    }
                    throw new SAXException("unsupported field type: " + this.field.getType());
                }
                catch (IllegalAccessException e) {
                    throw new SAXException(e);
                }
            }
        } else {
            this.stack.pop();
        }
        this.field = null;
        this.value.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.value.append(ch, start, length);
    }

    static {
        NO_SUCH_OBJECT = new Object();
        Field f = null;
        try {
            f = BeanSAXContentHandler.class.getDeclaredField("NO_SUCH_OBJECT");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        NO_SUCH_FIELD = f;
    }

    static class CollectionWrapper {
        private Collection<Object> collection;
        private Class clazz;

        public CollectionWrapper(Collection<Object> collection, Class clazz) {
            this.collection = collection;
            this.clazz = clazz;
        }

        public Object add() throws InstantiationException, IllegalAccessException {
            Object child = this.clazz.newInstance();
            this.collection.add(child);
            return child;
        }
    }
}

