/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class IniFile {
    private final File file;
    private final Map<String, Map<String, String>> multimap = new HashMap<String, Map<String, String>>();

    public IniFile(File file) {
        this.file = file;
        this.read();
    }

    protected void read() {
        try (BufferedReader br = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);){
            String line;
            String section = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("[")) {
                    section = this.getSectionFromLine(line);
                    continue;
                }
                this.addEntry(section, line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addEntry(String section, String line) {
        int pos = line.indexOf(61);
        if (pos > 0) {
            String key = line.substring(0, pos).trim();
            String value = line.substring(pos + 1).trim();
            this.multimap.computeIfAbsent(section, k -> new HashMap()).put(key, value);
        }
    }

    private String getSectionFromLine(String line) {
        return line.substring(line.startsWith("[profile ") ? 9 : 1, line.length() - 1);
    }

    public String getString(String section, String key) {
        return (String)this.multimap.getOrDefault(section, Collections.emptyMap()).get(key);
    }

    public Map<String, String> getSection(String section) {
        return this.multimap.get(section);
    }
}

