/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.util;

import com.carepay.aws.util.ClassUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class JsonParser {
    public <T> T parse(InputStream is, Class<?> clazz) throws IOException {
        return (T)this.parseValue(new PushbackReader(new InputStreamReader(is)), clazz);
    }

    protected Object parseValue(PushbackReader reader, Type clazz) throws IOException {
        try {
            int ch;
            while ((ch = reader.read()) > -1) {
                if (ch == 123) {
                    Object obj = ((Class)clazz).newInstance();
                    this.parseField(reader, obj);
                    return obj;
                }
                if (ch == 91) {
                    return this.parseArray(reader, clazz);
                }
                if (Character.isDigit(ch)) {
                    reader.unread(ch);
                    return this.parseNumber(reader, this.typeToClass(clazz));
                }
                if (ch == 34) {
                    return this.parseStringValue(reader, clazz);
                }
                if (ch == 116) {
                    return this.parseTrue(reader);
                }
                if (ch == 102) {
                    return this.parseFalse(reader);
                }
                if (ch == 110) {
                    return this.parseNull(reader);
                }
                if (Character.isWhitespace(ch)) continue;
                throw new UnexpectedCharacterException(ch);
            }
            throw new UnexpectedEndOfStreamException();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException(e);
        }
    }

    private Comparable<? extends Comparable<?>> parseStringValue(PushbackReader reader, Type clazz) throws IOException {
        String str = this.parseString(reader);
        if (clazz instanceof Class && Instant.class.isAssignableFrom((Class)clazz)) {
            return Instant.parse(str);
        }
        return str;
    }

    private Class<?> typeToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public void parseField(PushbackReader reader, Object obj) throws IOException {
        int ch;
        block0: while ((ch = reader.read()) > -1) {
            if (ch == 34) {
                String name = this.parseString(reader);
                Optional<Field> field = ClassUtils.findField(obj.getClass(), name);
                while ((ch = reader.read()) > -1) {
                    if (ch == 58) {
                        Object value = this.parseValue(reader, (Type)((Object)field.map(Field::getGenericType).orElse((Type)((Object)Object.class))));
                        field.ifPresent(f -> {
                            try {
                                f.setAccessible(true);
                                f.set(obj, value);
                            }
                            catch (IllegalAccessException e) {
                                throw new IllegalStateException(e);
                            }
                        });
                        continue block0;
                    }
                    if (Character.isWhitespace(ch)) continue;
                    throw new UnexpectedCharacterException(ch);
                }
                continue;
            }
            if (ch == 125) {
                return;
            }
            if (ch == 44 || Character.isWhitespace(ch)) continue;
            throw new UnexpectedCharacterException(ch);
        }
    }

    public List<Object> parseArray(PushbackReader reader, Type collectionClass) throws IOException {
        int ch;
        Class clazz = (Class)((ParameterizedType)collectionClass).getActualTypeArguments()[0];
        ArrayList<Object> list = new ArrayList<Object>();
        while ((ch = reader.read()) > -1) {
            if (Character.isWhitespace(ch)) continue;
            if (ch == 93) {
                return list;
            }
            if (ch == 44) continue;
            reader.unread(ch);
            list.add(this.parseValue(reader, clazz));
        }
        throw new UnexpectedEndOfStreamException();
    }

    private String parseString(PushbackReader reader) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = reader.read()) > -1) {
            if (ch == 34) {
                return sb.toString();
            }
            if (ch == 92) {
                sb.append((char)reader.read());
                continue;
            }
            sb.append((char)ch);
        }
        throw new UnexpectedEndOfStreamException();
    }

    private Object parseTrue(PushbackReader reader) throws IOException {
        int ch = reader.read();
        if (ch != 114 || (ch = reader.read()) != 117 || (ch = reader.read()) != 101) {
            throw new UnexpectedCharacterException(ch);
        }
        return Boolean.TRUE;
    }

    private boolean parseFalse(PushbackReader reader) throws IOException {
        int ch = reader.read();
        if (ch != 97 || (ch = reader.read()) != 108 || (ch = reader.read()) != 115 || (ch = reader.read()) != 101) {
            throw new UnexpectedCharacterException(ch);
        }
        return Boolean.FALSE;
    }

    private Object parseNumber(PushbackReader reader, Class<?> clazz) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = reader.read()) > -1) {
            if (Character.isDigit(ch) || ch == 46) {
                sb.append((char)ch);
                continue;
            }
            reader.unread(ch);
            break;
        }
        if (clazz == Long.TYPE || Long.class.isAssignableFrom(clazz)) {
            return Long.parseLong(sb.toString());
        }
        if (clazz == Double.TYPE || Double.class.isAssignableFrom(clazz)) {
            return Double.parseDouble(sb.toString());
        }
        if (clazz == Float.TYPE || Float.class.isAssignableFrom(clazz)) {
            return Float.valueOf(Float.parseFloat(sb.toString()));
        }
        if (Instant.class.isAssignableFrom(clazz)) {
            return Instant.ofEpochMilli(Long.parseLong(sb.toString()));
        }
        return Integer.parseInt(sb.toString());
    }

    private Object parseNull(PushbackReader reader) throws IOException {
        int ch = reader.read();
        if (ch != 117 || (ch = reader.read()) != 108 || (ch = reader.read()) != 108) {
            throw new UnexpectedCharacterException(ch);
        }
        return null;
    }

    static class UnexpectedEndOfStreamException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public UnexpectedEndOfStreamException() {
            super("Unexpected end of stream");
        }
    }

    static class UnexpectedCharacterException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public UnexpectedCharacterException(int ch) {
            super("Unexpected character: " + (char)ch);
        }
    }
}

