/*
 * Decompiled with CFR 0.152.
 */
package com.carepay.aws.util;

import com.carepay.aws.util.Hex;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class SHA256 {
    private static final String HMAC_SHA_256 = "HmacSHA256";
    public static final String EMPTY_STRING_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";

    private SHA256() {
        throw new IllegalStateException();
    }

    protected static MessageDigest getSha256MessageDigestInstance() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA-256");
    }

    protected static Mac getMacInstance() throws NoSuchAlgorithmException {
        return Mac.getInstance(HMAC_SHA_256);
    }

    public static String hash(String value) {
        return SHA256.hash(value.getBytes(StandardCharsets.UTF_8));
    }

    public static String hash(byte[] value) {
        if (value == null) {
            return EMPTY_STRING_SHA256;
        }
        return SHA256.hash(value, 0, value.length);
    }

    public static String hash(byte[] value, int offset, int length) {
        if (value == null || length == 0) {
            return EMPTY_STRING_SHA256;
        }
        try {
            MessageDigest sha256 = SHA256.getSha256MessageDigestInstance();
            sha256.update(value, offset, length);
            return Hex.encode(sha256.digest());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static byte[] sign(String value, byte[] key) {
        try {
            Mac mac = SHA256.getMacInstance();
            mac.init(new SecretKeySpec(key, HMAC_SHA_256));
            return mac.doFinal(value.getBytes(StandardCharsets.UTF_8));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

