/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.xhtmlrenderer.layout;

import org.docx4j.org.xhtmlrenderer.css.style.CalculatedStyle;
import org.docx4j.org.xhtmlrenderer.css.style.CssContext;
import org.docx4j.org.xhtmlrenderer.layout.InlineBoxMeasurements;
import org.docx4j.org.xhtmlrenderer.layout.LayoutContext;
import org.docx4j.org.xhtmlrenderer.layout.Styleable;
import org.docx4j.org.xhtmlrenderer.render.BlockBox;
import org.docx4j.org.xhtmlrenderer.render.Box;
import org.docx4j.org.xhtmlrenderer.render.FSFontMetrics;
import org.docx4j.org.xhtmlrenderer.render.InlineBox;
import org.docx4j.org.xhtmlrenderer.render.InlineLayoutBox;
import org.docx4j.org.xhtmlrenderer.render.InlineText;
import org.docx4j.org.xhtmlrenderer.render.StrutMetrics;

public class InlineBoxing {
    private InlineBoxing() {
    }

    public static void layoutContent(LayoutContext c, BlockBox box, int initialY, int breakAtLine) {
        int maxAvailableWidth = box.getContentWidth();
        CalculatedStyle parentStyle = box.getStyle();
        for (Styleable node : box.getInlineContent()) {
            if (node.getStyle().isInline()) {
                InlineBox iB = (InlineBox)node;
                CalculatedStyle style = iB.getStyle();
                if (!iB.isStartsHere()) continue;
                if (node.getElement() == null) {
                    // empty if block
                }
                InlineLayoutBox currentIB = new InlineLayoutBox(c, iB.getElement(), style, maxAvailableWidth);
                InlineBoxing.positionHorizontally(c, currentIB);
                continue;
            }
            BlockBox child = (BlockBox)node;
            if (child.getStyle().isNonFlowContent() || !child.getStyle().isInlineBlock() && !child.getStyle().isInlineTable()) continue;
            InlineBoxing.layoutInlineBlockContent(c, box, child, initialY);
        }
    }

    private static void positionHorizontally(CssContext c, InlineLayoutBox current) {
        for (int i = 0; i < current.getInlineChildCount(); ++i) {
            Object object;
            Object child = current.getInlineChild(i);
            if (child instanceof InlineLayoutBox) {
                InlineLayoutBox iB = (InlineLayoutBox)child;
                InlineBoxing.positionHorizontally(c, iB);
                continue;
            }
            if (child instanceof InlineText) {
                object = (InlineText)child;
                continue;
            }
            if (!(child instanceof Box)) continue;
            object = (Box)child;
        }
    }

    private static void layoutInlineBlockContent(LayoutContext c, BlockBox containingBlock, BlockBox inlineBlock, int initialY) {
        inlineBlock.setContainingBlock(containingBlock);
        inlineBlock.setContainingLayer(c.getLayer());
        inlineBlock.layout(c);
    }

    public static StrutMetrics createDefaultStrutMetrics(LayoutContext c, Box container) {
        FSFontMetrics strutM = container.getStyle().getFSFontMetrics(c);
        InlineBoxMeasurements measurements = InlineBoxing.getInitialMeasurements(c, container, strutM);
        return new StrutMetrics(strutM.getAscent(), measurements.getBaseline(), strutM.getDescent());
    }

    private static InlineBoxMeasurements getInitialMeasurements(LayoutContext c, Box container, FSFontMetrics strutM) {
        float lineHeight = container.getStyle().getLineHeight(c);
        int halfLeading = Math.round((lineHeight - container.getStyle().getFont((CssContext)c).size) / 2.0f);
        if (halfLeading > 0) {
            halfLeading = Math.round((lineHeight - (strutM.getDescent() + strutM.getAscent())) / 2.0f);
        }
        InlineBoxMeasurements measurements = new InlineBoxMeasurements();
        measurements.setBaseline((int)((float)halfLeading + strutM.getAscent()));
        measurements.setTextTop(halfLeading);
        measurements.setTextBottom((int)((float)measurements.getBaseline() + strutM.getDescent()));
        measurements.setInlineTop(halfLeading);
        measurements.setInlineBottom((int)((float)halfLeading + lineHeight));
        return measurements;
    }
}

