/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.xhtmlrenderer.resource;

import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.docx4j.org.xhtmlrenderer.resource.AbstractResource;
import org.docx4j.org.xhtmlrenderer.resource.FSEntityResolver;
import org.docx4j.org.xhtmlrenderer.util.Configuration;
import org.docx4j.org.xhtmlrenderer.util.XRLog;
import org.docx4j.org.xhtmlrenderer.util.XRRuntimeException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLResource
extends AbstractResource {
    private Document document;
    private static final XMLResourceBuilder XML_RESOURCE_BUILDER = new XMLResourceBuilder();
    private static boolean useConfiguredParser = true;

    private XMLResource(InputStream stream) {
        super(stream);
    }

    private XMLResource(InputSource source) {
        super(source);
    }

    public static XMLResource load(InputStream stream) {
        return XML_RESOURCE_BUILDER.createXMLResource(new XMLResource(stream));
    }

    public static XMLResource load(InputSource source) {
        return XML_RESOURCE_BUILDER.createXMLResource(new XMLResource(source));
    }

    public static XMLResource load(Reader reader) {
        return XML_RESOURCE_BUILDER.createXMLResource(new XMLResource(new InputSource(reader)));
    }

    public static XMLResource load(Source source) {
        return XML_RESOURCE_BUILDER.createXMLResource(source);
    }

    public Document getDocument() {
        return this.document;
    }

    void setDocument(Document document) {
        this.document = document;
    }

    public static final XMLReader newXMLReader() {
        String xmlReaderClass;
        XMLReader xmlReader;
        block12: {
            xmlReader = null;
            xmlReaderClass = Configuration.valueFor("xr.load.xml-reader");
            try {
                if (xmlReaderClass == null || xmlReaderClass.toLowerCase().equals("default") || !useConfiguredParser) break block12;
                try {
                    Class.forName(xmlReaderClass);
                }
                catch (Exception ex) {
                    useConfiguredParser = false;
                    XRLog.load(Level.WARNING, "The XMLReader class you specified as a configuration property could not be found. Class.forName() failed on " + xmlReaderClass + ". Please check classpath. Use value 'default' in FS configuration if necessary. Will now try JDK default.");
                }
                if (useConfiguredParser) {
                    xmlReader = XMLReaderFactory.createXMLReader(xmlReaderClass);
                }
            }
            catch (Exception ex) {
                XRLog.load(Level.WARNING, "Could not instantiate custom XMLReader class for XML parsing: " + xmlReaderClass + ". Please check classpath. Use value 'default' in FS configuration if necessary. Will now try JDK default.", ex);
            }
        }
        if (xmlReader == null) {
            try {
                xmlReader = XMLReaderFactory.createXMLReader();
                xmlReaderClass = "{JDK default}";
            }
            catch (Exception ex) {
                XRLog.general(ex.getMessage());
            }
        }
        if (xmlReader == null) {
            try {
                XRLog.load(Level.WARNING, "falling back on the default parser");
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                xmlReader = parser.getXMLReader();
                xmlReaderClass = "SAXParserFactory default";
            }
            catch (Exception ex) {
                XRLog.general(ex.getMessage());
            }
        }
        if (xmlReader == null) {
            throw new XRRuntimeException("Could not instantiate any SAX 2 parser, including JDK default. The name of the class to use should have been read from the org.xml.sax.driver System property, which is set to: ");
        }
        XRLog.load("SAX XMLReader in use (parser): " + xmlReader.getClass().getName());
        return xmlReader;
    }

    private static class XMLResourceBuilder {
        private XMLResourceBuilder() {
        }

        XMLResource createXMLResource(XMLResource target) {
            SAXSource input = null;
            DOMResult output = null;
            TransformerFactory xformFactory = null;
            Transformer idTransform = null;
            XMLReader xmlReader = null;
            long st = 0L;
            xmlReader = XMLResource.newXMLReader();
            this.addHandlers(xmlReader);
            this.setParserFeatures(xmlReader);
            st = System.currentTimeMillis();
            try {
                input = new SAXSource(xmlReader, target.getResourceInputSource());
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                output = new DOMResult(dbf.newDocumentBuilder().newDocument());
                xformFactory = TransformerFactory.newInstance();
                idTransform = xformFactory.newTransformer();
            }
            catch (Exception ex) {
                throw new XRRuntimeException("Failed on configuring SAX to DOM transformer.", ex);
            }
            try {
                idTransform.transform(input, output);
            }
            catch (Exception ex) {
                throw new XRRuntimeException("Can't load the XML resource (using TRaX transformer). " + ex.getMessage(), ex);
            }
            long end = System.currentTimeMillis();
            target.setElapsedLoadTime(end - st);
            XRLog.load("Loaded document in ~" + target.getElapsedLoadTime() + "ms");
            target.setDocument((Document)output.getNode());
            return target;
        }

        private void addHandlers(XMLReader xmlReader) {
            try {
                xmlReader.setEntityResolver(FSEntityResolver.instance());
                xmlReader.setErrorHandler(new ErrorHandler(){

                    public void error(SAXParseException ex) {
                        XRLog.load(ex.getMessage());
                    }

                    public void fatalError(SAXParseException ex) {
                        XRLog.load(ex.getMessage());
                    }

                    public void warning(SAXParseException ex) {
                        XRLog.load(ex.getMessage());
                    }
                });
            }
            catch (Exception ex) {
                throw new XRRuntimeException("Failed on configuring SAX parser/XMLReader.", ex);
            }
        }

        private void setParserFeatures(XMLReader xmlReader) {
            try {
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXException s) {
                XRLog.load(Level.WARNING, "Could not set validation/namespace features for XML parser,exception thrown.", s);
            }
            if (Configuration.isFalse("xr.load.configure-features", false)) {
                XRLog.load(Level.FINE, "SAX Parser: by request, not changing any parser features.");
                return;
            }
            this.setFeature(xmlReader, "http://xml.org/sax/features/validation", "xr.load.validation");
            this.setFeature(xmlReader, "http://xml.org/sax/features/string-interning", "xr.load.string-interning");
            this.setFeature(xmlReader, "http://xml.org/sax/features/namespaces", "xr.load.namespaces");
            this.setFeature(xmlReader, "http://xml.org/sax/features/namespace-prefixes", "xr.load.namespace-prefixes");
        }

        private void setFeature(XMLReader xmlReader, String featureUri, String configName) {
            try {
                xmlReader.setFeature(featureUri, Configuration.isTrue(configName, false));
                XRLog.load(Level.FINE, "SAX Parser feature: " + featureUri.substring(featureUri.lastIndexOf("/")) + " set to " + xmlReader.getFeature(featureUri));
            }
            catch (SAXNotSupportedException ex) {
                XRLog.load(Level.WARNING, "SAX feature not supported on this XMLReader: " + featureUri);
            }
            catch (SAXNotRecognizedException ex) {
                XRLog.load(Level.WARNING, "SAX feature not recognized on this XMLReader: " + featureUri + ". Feature may be properly named, but not recognized by this parser.");
            }
        }

        public XMLResource createXMLResource(Source source) {
            DOMResult output = null;
            TransformerFactory xformFactory = null;
            Transformer idTransform = null;
            long st = 0L;
            st = System.currentTimeMillis();
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                output = new DOMResult(dbf.newDocumentBuilder().newDocument());
                xformFactory = TransformerFactory.newInstance();
                idTransform = xformFactory.newTransformer();
            }
            catch (Exception ex) {
                throw new XRRuntimeException("Failed on configuring SAX to DOM transformer.", ex);
            }
            try {
                idTransform.transform(source, output);
            }
            catch (Exception ex) {
                throw new XRRuntimeException("Can't load the XML resource (using TRaX transformer). " + ex.getMessage(), ex);
            }
            long end = System.currentTimeMillis();
            XMLResource target = new XMLResource(null);
            target.setElapsedLoadTime(end - st);
            XRLog.load("Loaded document in ~" + target.getElapsedLoadTime() + "ms");
            target.setDocument((Document)output.getNode());
            return target;
        }
    }
}

