/*
 * Decompiled with CFR 0.152.
 */
package com.carmatechnologies.commons.testing.logging.impl;

import ch.qos.logback.classic.Level;
import ch.qos.logback.core.Appender;
import com.carmatechnologies.commons.testing.logging.api.ILogCapturer;
import com.carmatechnologies.commons.testing.logging.api.ILogCapturerFactory;
import com.carmatechnologies.commons.testing.logging.api.LogLevel;
import com.carmatechnologies.commons.testing.logging.impl.AbstractLogCapturerFactory;
import com.carmatechnologies.commons.testing.logging.logback.LogbackCollectionAppender;
import com.carmatechnologies.commons.testing.logging.logback.LogbackLogCapturer;
import com.carmatechnologies.commons.testing.utils.Preconditions;
import java.util.Collection;
import org.slf4j.Logger;

public class LogCapturerFactory
extends AbstractLogCapturerFactory
implements ILogCapturerFactory {
    protected boolean bindsToLoggingFramework(Logger logger) {
        return logger instanceof ch.qos.logback.classic.Logger;
    }

    protected String getName() {
        return ch.qos.logback.classic.Logger.class.getName();
    }

    protected ILogCapturer newLogCapturer(Logger slf4jLogger, LogLevel logLevel, boolean isAdditive, Collection<String> logs) {
        return new LogbackLogCapturer(slf4jLogger, (Appender)new LogbackCollectionAppender(logs), isAdditive, LogCapturerFactory.getLevel(logLevel));
    }

    private static Level getLevel(LogLevel logLevel) {
        Preconditions.checkNotNull((Object)logLevel, (String)"Log level must NOT be null.");
        switch (logLevel) {
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        throw new UnsupportedOperationException("No mapping from [" + logLevel + "] to [" + Level.class.getName() + "].");
    }
}

