/*
 * Decompiled with CFR 0.152.
 */
package com.carmatechnologies.commons.testing.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.core.Appender;
import com.carmatechnologies.commons.testing.logging.api.ILogCapturer;
import com.carmatechnologies.commons.testing.utils.Preconditions;
import org.slf4j.Logger;

public class LogbackLogCapturer
implements ILogCapturer {
    private final Appender appender;
    private final ch.qos.logback.classic.Logger logger;
    private final boolean initialAdditivity;
    private final Level initialLevel;
    private final boolean isAdditive;
    private final Level level;

    public LogbackLogCapturer(ch.qos.logback.classic.Logger logbackLogger, Appender appender, boolean isAdditive, Level level) {
        this.appender = (Appender)Preconditions.checkNotNull((Object)appender, (String)"Appender must NOT be null");
        this.logger = (ch.qos.logback.classic.Logger)Preconditions.checkNotNull((Object)logbackLogger, (String)"Logback logger must NOT be null");
        this.initialAdditivity = this.logger.isAdditive();
        this.initialLevel = this.logger.getLevel();
        this.isAdditive = isAdditive;
        this.level = (Level)Preconditions.checkNotNull((Object)level, (String)"Level must NOT be null.");
    }

    public LogbackLogCapturer(Logger slf4jLogger, Appender appender, boolean isAdditive, Level level) {
        this(LogbackLogCapturer.getLogger((Logger)Preconditions.checkNotNull((Object)slf4jLogger, (String)"SLF4J logger must NOT be null")), appender, isAdditive, level);
    }

    private static ch.qos.logback.classic.Logger getLogger(Logger slf4jLogger) {
        if (!(slf4jLogger instanceof ch.qos.logback.classic.Logger)) {
            throw new IllegalArgumentException("SLF4J logger must be a Logback logger, but was: " + slf4jLogger.getClass().getCanonicalName());
        }
        try {
            return (ch.qos.logback.classic.Logger)slf4jLogger;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to enable log capture for Logback", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableLogCapture() {
        ch.qos.logback.classic.Logger logger = this.logger;
        synchronized (logger) {
            this.logger.setAdditive(this.isAdditive);
            this.logger.setLevel(this.level);
            this.logger.addAppender(this.appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableLogCapture() {
        ch.qos.logback.classic.Logger logger = this.logger;
        synchronized (logger) {
            this.logger.detachAppender(this.appender);
            this.logger.setLevel(this.initialLevel);
            this.logger.setAdditive(this.initialAdditivity);
        }
    }
}

