/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cache;

import com.caucho.cache.CacheLifecycle;
import com.caucho.cache.CacheMXBean;
import com.caucho.cache.CacheManager;
import com.caucho.cache.CacheStatistics;
import com.caucho.cache.Configuration;
import com.caucho.cache.event.CacheEntryEventFilter;
import com.caucho.cache.event.CacheEntryListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

public interface Cache<K, V>
extends Iterable<Entry<K, V>>,
CacheLifecycle {
    public V get(Object var1);

    public Map<K, V> getAll(Set<? extends K> var1);

    public boolean containsKey(K var1);

    public void put(K var1, V var2);

    public V getAndPut(K var1, V var2);

    public void putAll(Map<? extends K, ? extends V> var1);

    public boolean putIfAbsent(K var1, V var2);

    public boolean remove(K var1);

    public boolean remove(K var1, V var2);

    public V getAndRemove(K var1);

    public boolean replace(K var1, V var2, V var3);

    public boolean replace(K var1, V var2);

    public V getAndReplace(K var1, V var2);

    public void removeAll(Set<? extends K> var1);

    public void removeAll();

    public Future<V> load(K var1);

    public Future<Map<K, ? extends V>> loadAll(Set<? extends K> var1);

    public Object invokeEntryProcessor(K var1, EntryProcessor<K, V> var2);

    public boolean registerCacheEntryListener(CacheEntryListener<? super K, ? super V> var1, boolean var2, CacheEntryEventFilter<? super K, ? super V> var3, boolean var4);

    public boolean unregisterCacheEntryListener(CacheEntryListener<?, ?> var1);

    public String getName();

    public CacheManager getCacheManager();

    public Configuration<K, V> getConfiguration();

    public CacheStatistics getStatistics();

    @Override
    public Iterator<Entry<K, V>> iterator();

    public CacheMXBean getMBean();

    public <T> T unwrap(Class<T> var1);

    public static interface EntryProcessor<K, V> {
        public Object process(MutableEntry<K, V> var1);
    }

    public static interface MutableEntry<K, V>
    extends Entry<K, V> {
        public boolean exists();

        public void remove();

        public void setValue(V var1);
    }

    public static interface Entry<K, V> {
        public K getKey();

        public V getValue();
    }
}

