/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cache;

import com.caucho.cache.CacheLoader;
import com.caucho.cache.CacheWriter;
import com.caucho.cache.ExpiryPolicy;
import com.caucho.cache.InvalidConfigurationException;
import com.caucho.cache.event.CacheEntryListenerRegistration;
import com.caucho.cache.transaction.IsolationLevel;
import com.caucho.cache.transaction.Mode;
import java.util.concurrent.TimeUnit;

public interface Configuration<K, V> {
    public boolean isReadThrough();

    public boolean isWriteThrough();

    public boolean isStoreByValue();

    public boolean isStatisticsEnabled();

    public boolean isTransactionsEnabled();

    public IsolationLevel getTransactionIsolationLevel();

    public Mode getTransactionMode();

    public Iterable<CacheEntryListenerRegistration<? super K, ? super V>> getCacheEntryListenerRegistrations();

    public CacheLoader<K, ? extends V> getCacheLoader();

    public CacheWriter<? super K, ? super V> getCacheWriter();

    public ExpiryPolicy<? super K, ? super V> getExpiryPolicy();

    public static enum ExpiryType {
        MODIFIED,
        ACCESSED;

    }

    public static class Duration {
        public static final Duration ETERNAL = new Duration();
        public static final Duration ZERO = new Duration(TimeUnit.SECONDS, 0L);
        private final TimeUnit timeUnit;
        private final long durationAmount;

        private Duration() {
            this.timeUnit = null;
            this.durationAmount = 0L;
        }

        public Duration(TimeUnit timeUnit, long durationAmount) {
            if (timeUnit == null) {
                throw new NullPointerException();
            }
            switch (timeUnit) {
                case NANOSECONDS: 
                case MICROSECONDS: {
                    throw new InvalidConfigurationException();
                }
            }
            this.timeUnit = timeUnit;
            if (durationAmount < 0L) {
                throw new IllegalArgumentException();
            }
            this.durationAmount = durationAmount;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public long getDurationAmount() {
            return this.durationAmount;
        }

        public boolean isEternal() {
            return this.timeUnit == null && this.durationAmount == 0L;
        }

        public long getAdjustedTime(long time) {
            if (this.isEternal()) {
                return Long.MAX_VALUE;
            }
            return time + this.timeUnit.toMillis(this.durationAmount);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.getDurationAmount() + "," + (Object)((Object)this.getTimeUnit()) + "]";
        }
    }
}

