/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cache;

import com.caucho.cache.Cache;
import com.caucho.cache.Configuration;

public interface ExpiryPolicy<K, V> {
    public Configuration.Duration getTTLForCreatedEntry(Cache.Entry<? extends K, ? extends V> var1);

    public Configuration.Duration getTTLForAccessedEntry(Cache.Entry<? extends K, ? extends V> var1, Configuration.Duration var2);

    public Configuration.Duration getTTLForModifiedEntry(Cache.Entry<? extends K, ? extends V> var1, Configuration.Duration var2);

    public static final class Default<K, V>
    implements ExpiryPolicy<K, V> {
        @Override
        public Configuration.Duration getTTLForCreatedEntry(Cache.Entry<? extends K, ? extends V> entry) {
            return Configuration.Duration.ETERNAL;
        }

        @Override
        public Configuration.Duration getTTLForAccessedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return duration;
        }

        @Override
        public Configuration.Duration getTTLForModifiedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return duration;
        }

        public int hashCode() {
            return Default.class.hashCode();
        }

        public boolean equals(Object value) {
            return value instanceof Default;
        }

        public String toString() {
            return this.getClass().getName() + "[]";
        }
    }

    public static final class Modified<K, V>
    implements ExpiryPolicy<K, V> {
        private final Configuration.Duration _expiryDuration;

        public Modified(Configuration.Duration expiryDuration) {
            this._expiryDuration = expiryDuration;
        }

        @Override
        public Configuration.Duration getTTLForCreatedEntry(Cache.Entry<? extends K, ? extends V> entry) {
            return this._expiryDuration;
        }

        @Override
        public Configuration.Duration getTTLForAccessedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return this._expiryDuration;
        }

        @Override
        public Configuration.Duration getTTLForModifiedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return duration;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this._expiryDuration + "]";
        }
    }

    public static final class Accessed<K, V>
    implements ExpiryPolicy<K, V> {
        private Configuration.Duration expiryDuration;

        public Accessed(Configuration.Duration expiryDuration) {
            this.expiryDuration = expiryDuration;
        }

        @Override
        public Configuration.Duration getTTLForCreatedEntry(Cache.Entry<? extends K, ? extends V> entry) {
            return this.expiryDuration;
        }

        @Override
        public Configuration.Duration getTTLForAccessedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return this.expiryDuration;
        }

        @Override
        public Configuration.Duration getTTLForModifiedEntry(Cache.Entry<? extends K, ? extends V> entry, Configuration.Duration duration) {
            return duration;
        }

        public String toString() {
            return this.getClass().getName() + "[]";
        }
    }
}

