/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.embeddable;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;

public abstract class EJBContainer {
    private static Logger log = Logger.getLogger(EJBContainer.class.getName());
    private static final String PROVIDER_RESOURCE = "META-INF/services/javax.ejb.spi.EJBContainerProvider";
    public static final String APP_NAME = "javax.ejb.embeddable.appName";
    public static final String MODULES = "javax.ejb.embeddable.modules";
    public static final String PROVIDER = "javax.ejb.embeddable.provider";

    public static EJBContainer createEJBContainer() throws EJBException {
        return EJBContainer.createEJBContainer(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EJBContainer createEJBContainer(Map<?, ?> properties) throws EJBException {
        Class<?> cl = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> providerURLs = loader.getResources(PROVIDER_RESOURCE);
            while (providerURLs.hasMoreElements()) {
                cl = EJBContainer.loadProviderClass(providerURLs.nextElement(), loader);
                try {
                    EJBContainerProvider provider = (EJBContainerProvider)cl.newInstance();
                    EJBContainer container = provider.createEJBContainer(properties);
                    if (container == null) continue;
                    return container;
                }
                catch (IllegalAccessException e) {
                    throw new EJBException(e);
                }
                catch (InstantiationException e) {
                    throw new EJBException(e);
                    return null;
                }
            }
        }
        catch (IOException e) {
            throw new EJBException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> loadProviderClass(URL url, ClassLoader loader) {
        InputStream is = null;
        try {
            int ch;
            is = url.openStream();
            while ((ch = is.read()) >= 0) {
                if (Character.isWhitespace((char)ch)) continue;
                if (ch == 35) {
                    while (ch >= 0 && ch != 10 && ch != 13) {
                        ch = is.read();
                    }
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                while (ch >= 0 && !Character.isWhitespace((char)ch)) {
                    sb.append((char)ch);
                    ch = is.read();
                }
                String className = sb.toString();
                Class<?> clazz = Class.forName(className, false, loader);
                return clazz;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public abstract Context getContext();

    public abstract void close();
}

