/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.lang.reflect.Array;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

public class ArrayELResolver
extends ELResolver {
    private final boolean _isReadOnly;

    public ArrayELResolver() {
        this._isReadOnly = false;
    }

    public ArrayELResolver(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        if (base.getClass().isArray()) {
            return base.getClass().getComponentType();
        }
        return null;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        if (base.getClass().isArray()) {
            context.setPropertyResolved(true);
            return null;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base == null) {
            return null;
        }
        if (base.getClass().isArray()) {
            context.setPropertyResolved(true);
            int index = ArrayELResolver.getIndex(property);
            if (index < 0 || Array.getLength(base) <= index) {
                throw new PropertyNotFoundException("array index '" + index + "' is invalid");
            }
            return base.getClass().getComponentType();
        }
        return null;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            return null;
        }
        if (base.getClass().isArray()) {
            context.setPropertyResolved(true);
            int index = ArrayELResolver.getIndex(property);
            if (0 <= index && index < Array.getLength(base)) {
                return Array.get(base, index);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null) {
            return false;
        }
        if (base.getClass().isArray()) {
            context.setPropertyResolved(true);
            int index = ArrayELResolver.getIndex(property);
            if (index < 0 || index >= Array.getLength(base)) {
                throw new PropertyNotFoundException("array index '" + index + "' is invalid");
            }
            return this._isReadOnly;
        }
        return false;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base != null && base.getClass().isArray()) {
            context.setPropertyResolved(true);
            if (this._isReadOnly) {
                throw new PropertyNotWritableException("resolver is read-only");
            }
            int index = ArrayELResolver.getIndex(property);
            Class<?> componentType = base.getClass().getComponentType();
            if (value != null && !componentType.isAssignableFrom(value.getClass())) {
                throw new ClassCastException(value.getClass().getName() + " cannot be cast to " + componentType.getName());
            }
            if (0 <= index && index < Array.getLength(base)) {
                Array.set(base, index, value);
            } else {
                throw new PropertyNotFoundException("array index '" + index + "' is invalid");
            }
        }
    }

    static int getIndex(Object property) {
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            try {
                return Integer.parseInt((String)property);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("can't convert '" + property + "' to long.");
            }
        }
        throw new IllegalArgumentException("can't convert '" + property + "' to long.");
    }
}

