/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

public abstract class ExpressionFactory {
    private static final Logger log = Logger.getLogger(ExpressionFactory.class.getName());
    private static final String SERVICE = "META-INF/services/javax.el.ExpressionFactory";

    public abstract Object coerceToType(Object var1, Class<?> var2) throws ELException;

    public abstract MethodExpression createMethodExpression(ELContext var1, String var2, Class<?> var3, Class<?>[] var4) throws ELException;

    public abstract ValueExpression createValueExpression(ELContext var1, String var2, Class<?> var3) throws ELException;

    public abstract ValueExpression createValueExpression(Object var1, Class<?> var2) throws ELException;

    public static ExpressionFactory newInstance() {
        return ExpressionFactory.newInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExpressionFactory newInstance(Properties properties) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String factoryName = null;
        URL url = loader.getResource(SERVICE);
        if (url != null) {
            InputStream is = null;
            try {
                is = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                factoryName = reader.readLine();
            }
            catch (IOException e) {
                log.log(Level.FINEST, "error reading from " + url, e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    log.log(Level.FINEST, "error closing input stream " + url, e);
                }
            }
        }
        if (factoryName == null) {
            String javaHome = System.getProperty("java.home");
            char slash = File.separatorChar;
            File file = new File(javaHome + slash + "lib" + slash + "el.properties");
            if (file.exists()) {
                Properties elProperties = new Properties();
                Reader reader = null;
                try {
                    reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    elProperties.load(reader);
                    factoryName = elProperties.getProperty("javax.el.ExpressionFactory");
                }
                catch (FileNotFoundException e) {
                    log.log(Level.FINEST, "file " + file + " does not exist", e);
                }
                catch (UnsupportedEncodingException e) {
                }
                catch (IOException e) {
                    log.log(Level.FINEST, "error reading from file " + file);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.FINEST, e.getMessage(), e);
                    }
                }
            }
        }
        if (factoryName == null) {
            factoryName = System.getProperty("javax.el.ExpressionFactory");
        }
        if (factoryName == null) {
            factoryName = "com.caucho.el.ExpressionFactoryImpl";
        }
        try {
            Class<?> c = loader.loadClass(factoryName);
            ExpressionFactory result = null;
            if (properties != null) {
                try {
                    Constructor<?> constructor = c.getConstructor(Properties.class);
                    result = (ExpressionFactory)constructor.newInstance(properties);
                }
                catch (NoSuchMethodException e) {
                    log.finest("class " + factoryName + " does not declare constructor accepting instance of java.util.Properties");
                }
                catch (InvocationTargetException e) {
                    String error = "exception initializing " + factoryName + " using constructor accepting java.util.Properties";
                    log.log(Level.FINEST, error, e);
                    throw new ELException(error, e);
                }
            }
            if (result == null) {
                result = (ExpressionFactory)c.newInstance();
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new ELException("can't create an instance of class " + factoryName, e);
        }
        catch (IllegalAccessException e) {
            throw new ELException("can't create an instance of class " + factoryName, e);
        }
        catch (ClassNotFoundException e) {
            throw new ELException(e.getMessage(), e);
        }
    }
}

