/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;

public class ResourceBundleELResolver
extends ELResolver {
    private static final Logger log = Logger.getLogger(ResourceBundleELResolver.class.getName());

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof ResourceBundle) {
            return String.class;
        }
        return null;
    }

    public Iterator getFeatureDescriptors(ELContext context, Object base) {
        if (!(base instanceof ResourceBundle)) {
            return null;
        }
        ResourceBundle bundle = (ResourceBundle)base;
        ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>();
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            FeatureDescriptor desc = new FeatureDescriptor();
            desc.setName(key);
            desc.setDisplayName(key);
            desc.setShortDescription("");
            desc.setExpert(false);
            desc.setHidden(false);
            desc.setPreferred(true);
            desc.setValue("type", String.class);
            desc.setValue("resolvableAtDesignTime", Boolean.TRUE);
            list.add(desc);
        }
        return list.iterator();
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base instanceof ResourceBundle) {
            context.setPropertyResolved(true);
            return null;
        }
        return null;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        String key;
        if (context == null) {
            throw new NullPointerException();
        }
        if (!(base instanceof ResourceBundle)) {
            return null;
        }
        context.setPropertyResolved(true);
        if (property == null) {
            return null;
        }
        try {
            key = String.valueOf(property);
        }
        catch (Exception e) {
            throw new ELException("Can't convert property of class " + property.getClass() + " to String", e);
        }
        ResourceBundle bundle = (ResourceBundle)base;
        Object value = null;
        try {
            value = bundle.getObject(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        return "???" + key + "???";
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof ResourceBundle) {
            context.setPropertyResolved(true);
            return true;
        }
        return true;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base instanceof ResourceBundle) {
            context.setPropertyResolved(true);
            throw new PropertyNotWritableException(String.valueOf(base));
        }
    }
}

