/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AnnotationLiteral<T extends Annotation>
implements Annotation,
Serializable {
    private static final Logger log = Logger.getLogger(AnnotationLiteral.class.getName());
    private static WeakHashMap<Class<?>, SoftReference<MethodMatch[]>> _annMap = new WeakHashMap();
    private transient Class<T> _annotationType;
    private transient MethodMatch[] _methods;
    private transient int _hashCode;

    protected AnnotationLiteral() {
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        if (this._annotationType == null) {
            this.fillAnnotationType(this.getClass());
        }
        return this._annotationType;
    }

    private void fillAnnotationType(Class<?> cl) {
        if (cl == null) {
            throw new UnsupportedOperationException(this.getClass().toString());
        }
        Type type = cl.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            this._annotationType = (Class)pType.getActualTypeArguments()[0];
        } else {
            this.fillAnnotationType(cl.getSuperclass());
        }
    }

    @Override
    public boolean equals(Object o) {
        Class<? extends Annotation> annTypeB;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Annotation)) {
            return false;
        }
        Class<Annotation> annTypeA = this.annotationType();
        if (!annTypeA.equals(annTypeB = ((Annotation)o).annotationType())) {
            return false;
        }
        for (MethodMatch annMethod : this.getMethods()) {
            try {
                if (annMethod.invokeMatch(this, o)) continue;
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this._hashCode != 0) {
            return this._hashCode;
        }
        int hash = 0;
        for (MethodMatch annMethod : this.getMethods()) {
            try {
                hash += 127 * annMethod.getName().hashCode() ^ annMethod.hashCode(this);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this._hashCode = hash;
        return hash;
    }

    private MethodMatch[] getMethods() {
        if (this._methods == null) {
            MethodMatch[] matchArray;
            Class<Annotation> annType = this.annotationType();
            SoftReference<MethodMatch[]> matchListRef = _annMap.get(annType);
            if (matchListRef != null && (matchArray = matchListRef.get()) != null) {
                return matchArray;
            }
            ArrayList<ArrayMethodMatch> matchList = new ArrayList<ArrayMethodMatch>();
            for (Method method : annType.getDeclaredMethods()) {
                if (method.getParameterTypes().length > 0 || method.getDeclaringClass() == Annotation.class || method.getDeclaringClass() == Object.class) continue;
                MethodMatch match = method.getReturnType().isArray() ? new ArrayMethodMatch(method) : new MethodMatch(method);
                matchList.add((ArrayMethodMatch)match);
            }
            MethodMatch[] methods = new MethodMatch[matchList.size()];
            matchList.toArray(methods);
            if (methods.length > 0 && !annType.isAssignableFrom(this.getClass())) {
                throw new IllegalStateException("Annotation literal '" + this.getClass() + "' must implement '" + annType.getName() + "' because it has member values.");
            }
            _annMap.put(annType, new SoftReference<MethodMatch[]>(methods));
            this._methods = methods;
        }
        return this._methods;
    }

    @Override
    public String toString() {
        return "@" + this.annotationType().getName() + "()";
    }

    private static class ArrayMethodMatch
    extends MethodMatch {
        ArrayMethodMatch(Method method) {
            super(method);
        }

        @Override
        public boolean isMatch(Object a, Object b) {
            Object[] arrayA = (Object[])a;
            Object[] arrayB = (Object[])b;
            if (arrayA == arrayB) {
                return true;
            }
            if (arrayA == null || arrayB == null) {
                return false;
            }
            if (arrayA.length != arrayB.length) {
                return false;
            }
            for (Object valueA : arrayA) {
                if (this.isMatch(valueA, arrayB)) continue;
                return false;
            }
            return true;
        }

        private boolean isMatch(Object aValue, Object[] bArray) {
            for (Object bValue : bArray) {
                if (aValue == bValue) {
                    return true;
                }
                if (aValue == null || !aValue.equals(bValue)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int valueHashCode(Object value) {
            Object[] array = (Object[])value;
            return Arrays.hashCode(array);
        }
    }

    private static class MethodMatch {
        private final Method _method;

        MethodMatch(Method method) {
            this._method = method;
            method.setAccessible(true);
        }

        public String getName() {
            return this._method.getName();
        }

        public final boolean invokeMatch(Object a, Object b) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return this.isMatch(this._method.invoke(a, new Object[0]), this._method.invoke(b, new Object[0]));
        }

        public boolean isMatch(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }

        public final int hashCode(Object o) {
            try {
                Object value = this._method.invoke(o, new Object[0]);
                if (value != null) {
                    return this.valueHashCode(value);
                }
                return 0;
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
                return 0;
            }
        }

        public int valueHashCode(Object value) {
            return value.hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._method + "]";
        }
    }
}

