/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.util;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeLiteral<T>
implements Serializable {
    private transient Type _type;

    protected TypeLiteral() {
    }

    public final Type getType() {
        if (this._type == null) {
            Type type = this.getClass().getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                this._type = pType.getActualTypeArguments()[0];
            } else {
                throw new UnsupportedOperationException(type.toString());
            }
        }
        return this._type;
    }

    public final Class<T> getRawType() {
        Type type = this.getType();
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return (Class)pType.getRawType();
        }
        throw new UnsupportedOperationException(type.toString());
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeLiteral)) {
            return false;
        }
        TypeLiteral lit = (TypeLiteral)o;
        return this.getType().equals(lit.getType());
    }

    public String toString() {
        return "TypeLiteral[" + this.getType() + "]";
    }
}

