/*
 * Decompiled with CFR 0.152.
 */
package javax.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class QueueRequestor {
    private QueueSession _session;
    private Queue _queue;
    private QueueSender _sender;

    public QueueRequestor(QueueSession session, Queue queue) throws JMSException {
        this._session = session;
        this._queue = queue;
        this._sender = this._session.createSender(queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message request(Message message) throws JMSException {
        TemporaryQueue tempQueue = this._session.createTemporaryQueue();
        try {
            Message message2;
            message.setJMSReplyTo(tempQueue);
            this._sender.send(message);
            QueueReceiver receiver = this._session.createReceiver(tempQueue);
            try {
                message2 = receiver.receive();
            }
            catch (Throwable throwable) {
                receiver.close();
                throw throwable;
            }
            receiver.close();
            return message2;
        }
        finally {
            tempQueue.delete();
        }
    }

    public void close() throws JMSException {
        this._sender.close();
        this._session.close();
    }
}

