/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUtil;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.ProviderUtil;

public class Persistence {
    private static final Logger log = Logger.getLogger(Persistence.class.getName());
    private static final String SERVICE = "META-INF/services/javax.persistence.spi.PersistenceProvider";
    private static WeakHashMap<ClassLoader, String[]> _providerMap = new WeakHashMap();
    private static final String AMBER_PROVIDER = "com.caucho.amber.manager.AmberPersistenceProvider";
    @Deprecated
    protected static final Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    @Deprecated
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PeristenceProvider";

    public static EntityManagerFactory createEntityManagerFactory(String name) {
        for (PersistenceProvider provider : Persistence.getProviderList()) {
            EntityManagerFactory factory = provider.createEntityManagerFactory(name, null);
            if (factory == null) continue;
            return factory;
        }
        throw new PersistenceException("no persistence provider found for `" + name + '\'');
    }

    public static EntityManagerFactory createEntityManagerFactory(String name, Map props) {
        for (PersistenceProvider provider : Persistence.getProviderList()) {
            EntityManagerFactory factory = provider.createEntityManagerFactory(name, props);
            if (factory == null) continue;
            return factory;
        }
        throw new PersistenceException("no persistence provider found for `" + name + '\'');
    }

    public static PersistenceUtil getPersistenceUtil() {
        return new PersistenceUtilImpl(Persistence.getProviderList());
    }

    private static PersistenceProvider[] getProviderList() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String[] providerClassNames = _providerMap.get(loader);
        if (providerClassNames != null) {
            return Persistence.loadProviders(providerClassNames);
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            Class<?> cl = Class.forName(AMBER_PROVIDER, false, loader);
            list.add(cl.getName());
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        try {
            Enumeration<URL> e = loader.getResources(SERVICE);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                list.addAll(Persistence.loadProviders(url, loader));
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        providerClassNames = new String[list.size()];
        list.toArray(providerClassNames);
        _providerMap.put(loader, providerClassNames);
        return Persistence.loadProviders(providerClassNames);
    }

    private static PersistenceProvider[] loadProviders(String[] classNames) {
        int size = classNames.length;
        PersistenceProvider[] providers = new PersistenceProvider[size];
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (int i = 0; i < size; ++i) {
            try {
                PersistenceProvider provider;
                Class<?> cl = Class.forName(classNames[i], false, classLoader);
                providers[i] = provider = (PersistenceProvider)cl.newInstance();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadProviders(URL url, ClassLoader loader) {
        ArrayList<String> providers = new ArrayList<String>();
        InputStream is = null;
        try {
            int ch;
            is = url.openStream();
            while ((ch = is.read()) >= 0) {
                if (Character.isWhitespace((char)ch)) continue;
                if (ch == 35) {
                    while (ch >= 0 && ch != 10 && ch != 13) {
                        ch = is.read();
                    }
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                while (ch >= 0 && !Character.isWhitespace((char)ch)) {
                    sb.append((char)ch);
                    ch = is.read();
                }
                String className = sb.toString();
                try {
                    Class<?> cl = Class.forName(className, false, loader);
                    providers.add(cl.getName());
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return providers;
    }

    private static class PersistenceUtilImpl
    implements PersistenceUtil {
        private PersistenceProvider[] _providerList;

        PersistenceUtilImpl(PersistenceProvider[] providerList) {
            this._providerList = providerList;
        }

        @Override
        public boolean isLoaded(Object entity, String attributeName) {
            LoadState state;
            ProviderUtil util;
            for (PersistenceProvider provider : this._providerList) {
                try {
                    util = provider.getProviderUtil();
                    if (util == null) continue;
                    state = util.isLoadedWithoutReference(entity, attributeName);
                    if (state == LoadState.LOADED) {
                        return true;
                    }
                    if (state != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (Exception e) {
                    log.log(Level.FINER, provider + ": " + e.toString(), e);
                }
                catch (AbstractMethodError e) {
                    log.log(Level.FINER, provider + ": " + e.toString(), e);
                }
            }
            for (PersistenceProvider provider : this._providerList) {
                try {
                    util = provider.getProviderUtil();
                    if (util == null) continue;
                    state = util.isLoadedWithReference(entity, attributeName);
                    if (state == LoadState.LOADED) {
                        return true;
                    }
                    if (state != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (Exception e) {
                    log.log(Level.FINER, provider + ": " + e.toString(), e);
                }
                catch (AbstractMethodError e) {
                    log.log(Level.FINER, provider + ": " + e.toString(), e);
                }
            }
            return true;
        }

        @Override
        public boolean isLoaded(Object entity) {
            for (PersistenceProvider provider : this._providerList) {
                try {
                    ProviderUtil util = provider.getProviderUtil();
                    if (util == null) continue;
                    LoadState state = util.isLoaded(entity);
                    if (state == LoadState.LOADED) {
                        return true;
                    }
                    if (state != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (AbstractMethodError e) {
                    log.log(Level.FINER, provider + ": " + e.toString(), e);
                }
                catch (Exception e) {
                    log.log(Level.FINER, provider + ": " + e.toString(), e);
                }
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[]";
        }
    }
}

