/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public abstract class GenericServlet
implements Servlet,
ServletConfig,
Serializable {
    private static final Logger log = Logger.getLogger(GenericServlet.class.getName());
    private transient ServletConfig _config;

    @Override
    public void init(ServletConfig config) throws ServletException {
        this._config = config;
        this.init();
    }

    public void init() throws ServletException {
    }

    @Override
    public ServletConfig getServletConfig() {
        return this._config;
    }

    @Override
    public String getServletName() {
        ServletConfig config = this.getServletConfig();
        return config != null ? config.getServletName() : this.getClass().getName();
    }

    @Override
    public String getInitParameter(String name) {
        ServletConfig config = this.getServletConfig();
        return config != null ? config.getInitParameter(name) : null;
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        ServletConfig config = this.getServletConfig();
        return config != null ? config.getInitParameterNames() : null;
    }

    @Override
    public ServletContext getServletContext() {
        ServletConfig config = this.getServletConfig();
        return config != null ? config.getServletContext() : null;
    }

    @Override
    public String getServletInfo() {
        return "";
    }

    public void log(String message) {
        log.config(this.getServletName() + ": " + message);
    }

    public void log(String message, Throwable cause) {
        ServletContext app = this.getServletContext();
        if (app != null) {
            app.log(this.getClass().getName() + ": " + message, cause);
        }
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getServletContext() + "]";
    }
}

