/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.Serializable;

public class Cookie
implements Cloneable,
Serializable {
    private String name;
    private String value;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version = 0;
    private boolean isHttpOnly;
    private static boolean[] validChar = new boolean[128];

    public Cookie(String name, String value) {
        int length = name.length();
        for (int i = length - 1; i >= 0; --i) {
            char ch = name.charAt(i);
            if (ch >= '\u007f' || !validChar[ch]) {
                throw new IllegalArgumentException("illegal cookie name: " + name);
            }
            if (ch != '$' || i != 0) continue;
            throw new IllegalArgumentException("cookie can't start with '$'");
        }
        this.name = name;
        this.value = value;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isHttpOnly() {
        return this.isHttpOnly;
    }

    public void setHttpOnly(boolean isHttpOnly) {
        this.isHttpOnly = isHttpOnly;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Cookie[" + this.name + "=" + this.value);
        if (this.path != null) {
            sb.append(",path=" + this.path);
        }
        if (this.domain != null) {
            sb.append(",domain=" + this.domain);
        }
        if (this.maxAge > 0) {
            sb.append(",max-age=" + this.maxAge);
        }
        if (this.secure) {
            sb.append(",secure");
        }
        if (this.isHttpOnly) {
            sb.append(",httpOnly");
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        for (int i = 33; i < 127; ++i) {
            Cookie.validChar[i] = true;
        }
        Cookie.validChar[44] = false;
        Cookie.validChar[59] = false;
    }
}

