/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.core;

import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.el.ELContext;
import javax.el.ValueExpression;

public final class IteratedExpression {
    protected final ValueExpression orig;
    protected final String delims;

    public IteratedExpression(ValueExpression orig, String delims) {
        this.orig = orig;
        this.delims = delims;
    }

    public ValueExpression getValueExpression() {
        return this.orig;
    }

    public Object getItem(ELContext context, int i) {
        Object items = this.orig.getValue(context);
        if (items == null) {
            return null;
        }
        if (items instanceof List) {
            List list = (List)items;
            if (i >= 0 && i < list.size()) {
                return list.get(i);
            }
            return null;
        }
        if (items instanceof Iterable) {
            Iterator iter = ((Iterable)items).iterator();
            Object value = null;
            while (i-- >= 0) {
                if (!iter.hasNext()) {
                    return null;
                }
                value = iter.next();
            }
            return value;
        }
        if (items.getClass().isArray()) {
            return Array.get(items, i);
        }
        if (items instanceof Iterator) {
            Iterator iter = (Iterator)items;
            Object value = null;
            while (i-- >= 0) {
                if (!iter.hasNext()) {
                    return null;
                }
                value = iter.next();
            }
            return value;
        }
        if (items instanceof Enumeration) {
            Enumeration e = (Enumeration)items;
            Object value = null;
            while (i-- >= 0) {
                if (!e.hasMoreElements()) {
                    return null;
                }
                value = e.nextElement();
            }
            return value;
        }
        if (items instanceof Map) {
            Iterator iter = ((Map)items).entrySet().iterator();
            Map.Entry value = null;
            while (i-- >= 0) {
                if (!iter.hasNext()) {
                    return null;
                }
                value = iter.next();
            }
            return value;
        }
        if (items instanceof String) {
            String value = null;
            StringTokenizer tokenizer = this.delims == null ? new StringTokenizer((String)items) : new StringTokenizer((String)items, this.delims);
            while (i-- >= 0) {
                if (!tokenizer.hasMoreTokens()) {
                    return null;
                }
                value = tokenizer.nextToken().trim();
            }
            return value;
        }
        throw new IllegalStateException("unknown items value " + items);
    }

    public int hashCode() {
        return this.orig.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IteratedExpression)) {
            return false;
        }
        IteratedExpression expr = (IteratedExpression)o;
        return this.orig.equals(expr.orig);
    }
}

