/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.tlv;

import java.io.InputStream;
import java.util.Map;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ScriptFreeTLV
extends TagLibraryValidator {
    private boolean _isAllowDeclarations;
    private boolean _isAllowScriptlets;
    private boolean _isAllowExpressions;
    private boolean _isAllowRTExpressions;

    @Override
    public ValidationMessage[] validate(String prefix, String uri, PageData data) {
        Map<String, Object> init = this.getInitParameters();
        this._isAllowDeclarations = "true".equals(init.get("allowDeclarations"));
        this._isAllowScriptlets = "true".equals(init.get("allowScriptlets"));
        this._isAllowExpressions = "true".equals(init.get("allowExpressions"));
        this._isAllowRTExpressions = "true".equals(init.get("allowRTExpressions"));
        try {
            InputStream is = data.getInputStream();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            Handler handler = new Handler();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (Exception e) {
            return new ValidationMessage[]{new ValidationMessage("", e.getMessage())};
        }
        return null;
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            boolean isValid = true;
            if ("jsp:expression".equals(qName)) {
                isValid = ScriptFreeTLV.this._isAllowExpressions;
            } else if ("jsp:declaration".equals(qName)) {
                isValid = ScriptFreeTLV.this._isAllowDeclarations;
            } else if ("jsp:scriptlet".equals(qName)) {
                isValid = ScriptFreeTLV.this._isAllowScriptlets;
            }
            if (!isValid) {
                throw new SAXException(qName + " is not allowed in a script-free JSP page");
            }
            if (!ScriptFreeTLV.this._isAllowRTExpressions && attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String value = attributes.getValue(i);
                    if (value == null || value.indexOf("%=") < 0) continue;
                    throw new SAXException("Runtime expression <" + value + "> is not allowed in a script-free JSP page");
                }
            }
        }
    }
}

