/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import com.caucho.util.CharBuffer;

public class JavaParameterizedType
implements JType {
    private JClassLoader _loader;
    private JClass _rawClass;
    private JType[] _typeArgs;

    JavaParameterizedType(JClassLoader loader, JClass rawClass, JType[] args) {
        this._loader = loader;
        this._rawClass = rawClass;
        this._typeArgs = args;
    }

    @Override
    public String getName() {
        return this._rawClass.getName();
    }

    @Override
    public String getPrintName() {
        if (this._typeArgs.length == 0) {
            return this._rawClass.getPrintName();
        }
        CharBuffer cb = new CharBuffer();
        cb.append(this._rawClass.getPrintName());
        cb.append('<');
        for (int i = 0; i < this._typeArgs.length; ++i) {
            if (i != 0) {
                cb.append(',');
            }
            cb.append(this._typeArgs[i].getPrintName());
        }
        cb.append('>');
        return cb.toString();
    }

    @Override
    public JType[] getActualTypeArguments() {
        return this._typeArgs;
    }

    @Override
    public JClass getRawType() {
        return this._rawClass;
    }

    @Override
    public boolean isPrimitive() {
        return this._rawClass.isPrimitive();
    }

    @Override
    public boolean isPublic() {
        return this._rawClass.isPublic();
    }

    @Override
    public boolean isAbstract() {
        return this._rawClass.isAbstract();
    }

    @Override
    public boolean isFinal() {
        return this._rawClass.isFinal();
    }

    @Override
    public boolean isInterface() {
        return this._rawClass.isAbstract();
    }

    @Override
    public JClass getSuperClass() {
        return this._rawClass.getSuperClass();
    }

    @Override
    public JClass[] getInterfaces() {
        return this._rawClass.getInterfaces();
    }

    @Override
    public boolean isArray() {
        return this._rawClass.isArray();
    }

    @Override
    public JClass getComponentType() {
        return null;
    }

    @Override
    public boolean isAssignableTo(Class cl) {
        return this._rawClass.isAssignableTo(cl);
    }

    @Override
    public boolean isAssignableFrom(Class cl) {
        return this._rawClass.isAssignableFrom(cl);
    }

    @Override
    public boolean isAssignableFrom(JClass cl) {
        return this._rawClass.isAssignableFrom(cl);
    }

    @Override
    public JMethod[] getDeclaredMethods() {
        return this._rawClass.getDeclaredMethods();
    }

    @Override
    public JMethod[] getMethods() {
        return this._rawClass.getMethods();
    }

    @Override
    public JMethod getMethod(String name, JClass[] param) {
        return this._rawClass.getMethod(name, param);
    }

    @Override
    public JField[] getDeclaredFields() {
        return this._rawClass.getDeclaredFields();
    }

    @Override
    public JField[] getFields() {
        return this._rawClass.getFields();
    }
}

