/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import java.io.IOException;

public class MethodHandleConstant
extends ConstantPoolEntry {
    private int _referenceKind;
    private int _referenceIndex;

    MethodHandleConstant(ConstantPool pool, int index, int referenceKind, int referenceIndex) {
        super(pool, index);
        this._referenceKind = referenceKind;
        this._referenceIndex = referenceIndex;
    }

    public int getBaseMethodIndex() {
        return this._referenceKind;
    }

    public String getName() {
        return this.getConstantPool().getNameAndType(this._referenceIndex).getName();
    }

    public String getType() {
        return this.getConstantPool().getNameAndType(this._referenceIndex).getType();
    }

    public void setNameAndType(String name, String type) {
        this._referenceIndex = this.getConstantPool().addNameAndType(name, type).getIndex();
    }

    @Override
    void write(ByteCodeWriter out) throws IOException {
        out.write(15);
        out.write(this._referenceKind);
        out.writeShort(this._referenceIndex);
    }

    @Override
    public int export(ConstantPool target) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "(" + this.getType() + ")]";
    }
}

