/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.bytecode.ScopeAdapter;
import com.caucho.config.event.EventManager;
import com.caucho.config.inject.AbstractBean;
import com.caucho.config.inject.AnyLiteral;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.PassivationSetter;
import com.caucho.config.reflect.BaseType;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Singleton;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;

@Module
public class AbstractIntrospectedBean<T>
extends AbstractBean<T>
implements PassivationCapable,
PassivationSetter {
    private static final L10N L = new L10N(AbstractIntrospectedBean.class);
    private static final Logger log = Logger.getLogger(AbstractIntrospectedBean.class.getName());
    private static final HashSet<Class<?>> _reservedTypes = new HashSet();
    public static final Annotation[] CURRENT_ANN = new Annotation[]{DefaultLiteral.DEFAULT};
    private Annotated _annotated;
    private BaseType _baseType;
    private Set<Type> _typeClasses;
    private ArrayList<Annotation> _qualifiers = new ArrayList();
    private Class<? extends Annotation> _scope;
    private ArrayList<Annotation> _stereotypes = new ArrayList();
    private String _name;
    private boolean _isAlternative;
    private boolean _isPassivating;
    private String _passivationId;

    public AbstractIntrospectedBean(InjectManager manager, Type type, Annotated annotated) {
        super(manager);
        this._annotated = annotated;
        this._baseType = manager.createSourceBaseType(type);
        Set baseTypes = annotated.getTypeClosure();
        Typed typed = (Typed)annotated.getAnnotation(Typed.class);
        this._typeClasses = typed != null ? this.fillTyped(baseTypes, typed.value()) : baseTypes;
    }

    private LinkedHashSet<Type> fillTyped(Set<Type> closure, Class<?>[] values) {
        LinkedHashSet<Type> typeClasses = new LinkedHashSet<Type>();
        for (Class<?> cl : values) {
            this.fillType(typeClasses, closure, cl);
        }
        typeClasses.add((Type)((Object)Object.class));
        return typeClasses;
    }

    private void fillType(LinkedHashSet<Type> types, Set<Type> closure, Class<?> cl) {
        for (Type type : closure) {
            BaseType baseType;
            if (type.equals(cl)) {
                types.add(type);
                continue;
            }
            if (!(type instanceof BaseType) || !(baseType = (BaseType)((Object)type)).getRawClass().equals(cl)) continue;
            types.add(type);
        }
    }

    public BaseType getBaseType() {
        return this._baseType;
    }

    @Override
    public Class<?> getBeanClass() {
        return this._baseType.getRawClass();
    }

    @Override
    public final Class<?> getJavaClass() {
        return this._baseType.getRawClass();
    }

    public Type getTargetType() {
        return this._baseType.toType();
    }

    public String getTargetSimpleName() {
        return this._baseType.getSimpleName();
    }

    public String getTargetName() {
        return this._baseType.toString();
    }

    public Class<?> getTargetClass() {
        return this._baseType.getRawClass();
    }

    @Override
    public Annotated getAnnotated() {
        return this._annotated;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        LinkedHashSet<Annotation> set = new LinkedHashSet<Annotation>();
        for (Annotation qualifier : this._qualifiers) {
            set.add(qualifier);
        }
        return set;
    }

    @Override
    public String getId() {
        if (this._passivationId == null && this.isPassivating()) {
            this._passivationId = this.calculatePassivationId();
        }
        return this._passivationId;
    }

    @Override
    public void setPassivationId(String passivationId) {
        this._passivationId = passivationId;
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        LinkedHashSet<Class<? extends Annotation>> set = new LinkedHashSet<Class<? extends Annotation>>();
        for (Annotation stereotype : this._stereotypes) {
            set.add(stereotype.annotationType());
        }
        return set;
    }

    private Annotated getIntrospectedAnnotated() {
        return this._annotated;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this._scope;
    }

    @Override
    public Set<Type> getTypes() {
        return this._typeClasses;
    }

    @Override
    public boolean isAlternative() {
        return this._isAlternative;
    }

    @Override
    public void introspect() {
        super.introspect();
        this.introspect(this.getIntrospectedAnnotated());
    }

    protected void introspect(Annotated annotated) {
        this.introspectScope(annotated);
        this.introspectQualifiers(annotated);
        this.introspectName(annotated);
        if (annotated.isAnnotationPresent(Alternative.class)) {
            this._isAlternative = true;
        }
        this.introspectStereotypes(annotated);
        this.introspectSpecializes(annotated);
        this.introspectDefault();
        if (this.getScope().isAnnotationPresent(NormalScope.class)) {
            ScopeAdapter.validateType(annotated.getBaseType());
        }
    }

    protected void introspectScope(Annotated annotated) {
        if (this._scope != null) {
            return;
        }
        InjectManager inject = this.getBeanManager();
        for (Annotation ann : annotated.getAnnotations()) {
            if (!inject.isScope(ann.annotationType())) continue;
            if (this._scope != null && this._scope != ann.annotationType()) {
                throw new ConfigException(L.l("{0}: @Scope annotation @{1} conflicts with @{2}.  Java Injection components may only have a single @Scope.", (Object)this.getTargetName(), (Object)this._scope.getName(), (Object)ann.annotationType().getName()));
            }
            this._scope = ann.annotationType();
        }
    }

    protected void introspectQualifiers(Annotated annotated) {
        if (this._qualifiers.size() > 0) {
            return;
        }
        InjectManager inject = this.getBeanManager();
        for (Annotation ann : annotated.getAnnotations()) {
            String namedValue;
            if (!inject.isQualifier(ann.annotationType())) continue;
            if (ann.annotationType().equals(Named.class) && "".equals(namedValue = this.getNamedValue(ann))) {
                ann = Names.create(this.getDefaultName());
            }
            this._qualifiers.add(ann);
        }
    }

    protected void introspectName(Annotated annotated) {
        if (this._name != null) {
            return;
        }
        Annotation ann = annotated.getAnnotation(Named.class);
        if (ann != null) {
            String value = this.getNamedValue(ann);
            if (value == null) {
                value = "";
            }
            this._name = value;
        }
    }

    protected void introspectStereotypes(Annotated annotated) {
        Class<? extends Annotation> scope = null;
        for (Annotation stereotype : annotated.getAnnotations()) {
            Class<? extends Annotation> stereotypeType = stereotype.annotationType();
            Set<Annotation> stereotypeSet = this.getBeanManager().getStereotypeDefinition(stereotypeType);
            if (stereotypeSet == null) continue;
            this._stereotypes.add(stereotype);
            for (Annotation ann : stereotypeSet) {
                Class<? extends Annotation> annType = ann.annotationType();
                if (annType.isAnnotationPresent(Scope.class) || annType.isAnnotationPresent(NormalScope.class)) {
                    if (this._scope == null && scope != null && !scope.equals(annType)) {
                        throw new ConfigException(L.l("'{0}' is an invalid @Scope because a scope '{1}' has already been defined.  Only one @Scope or @NormalScope is allowed on a bean.", (Object)scope.getName(), (Object)annType.getName()));
                    }
                    scope = annType;
                }
                if (annType.equals(Named.class) && this._name == null) {
                    String namedValue = this.getNamedValue(ann);
                    this._name = "";
                    if (!"".equals(namedValue)) {
                        throw new ConfigException(L.l("@Named must not have a value in a @Stereotype definition, because @Stereotypes are used with multiple beans."));
                    }
                }
                if (annType.isAnnotationPresent(Qualifier.class) && !annType.equals(Named.class)) {
                    throw new ConfigException(L.l("'{0}' is not allowed on @Stereotype '{1}' because stereotypes may not have @Qualifier annotations", (Object)ann, (Object)stereotype));
                }
                if (!annType.equals(Alternative.class)) continue;
                this._isAlternative = true;
            }
        }
        if (this._scope == null) {
            this._scope = scope;
        }
    }

    void introspectObservers() {
        EventManager eventManager = this.getBeanManager().getEventManager();
        AnnotatedType annType = this.getAnnotatedType();
        for (AnnotatedMethod beanMethod : annType.getMethods()) {
            int param = EventManager.findObserverAnnotation(beanMethod);
            if (param < 0) continue;
            eventManager.addObserver(this, beanMethod);
        }
    }

    protected void introspectSpecializes(Annotated annotated) {
        if (!annotated.isAnnotationPresent(Specializes.class)) {
            return;
        }
        Type baseType = annotated.getBaseType();
        if (!(baseType instanceof Class)) {
            throw new ConfigException(L.l("{0}: invalid @Specializes bean because '{1}' is not a class.", (Object)this.getTargetName(), (Object)baseType));
        }
        Class baseClass = (Class)baseType;
        Class parentClass = baseClass.getSuperclass();
        if (baseClass.getSuperclass() == null || baseClass.getSuperclass().equals(Object.class)) {
            throw new ConfigException(L.l("{0}: invalid @Specializes bean because the superclass '{1}' is not a managed bean.", (Object)this.getTargetName(), (Object)baseClass.getSuperclass()));
        }
        if (annotated.isAnnotationPresent(Stateless.class) != parentClass.isAnnotationPresent(Stateless.class)) {
            throw new ConfigException(L.l("{0}: invalid @Specializes bean because the bean is a @Stateless bean but its parent is not.", (Object)this.getTargetName()));
        }
        if (annotated.isAnnotationPresent(Stateful.class) != parentClass.isAnnotationPresent(Stateful.class)) {
            throw new ConfigException(L.l("{0}: invalid @Specializes bean because the bean is a @Stateful bean but its parent is not.", (Object)this.getTargetName()));
        }
        if (annotated.isAnnotationPresent(Singleton.class) != parentClass.isAnnotationPresent(Singleton.class)) {
            throw new ConfigException(L.l("{0}: invalid @Specializes bean because the bean is a @Singleton bean but its parent is not.", (Object)this.getTargetName()));
        }
    }

    protected void introspectDefault() {
        boolean isQualifier = false;
        for (Annotation ann : this._qualifiers) {
            if (Named.class.equals(ann.annotationType()) || Any.class.equals(ann.annotationType())) continue;
            isQualifier = true;
        }
        if (!isQualifier) {
            this._qualifiers.add((Annotation)DefaultLiteral.DEFAULT);
        }
        this._qualifiers.add((Annotation)AnyLiteral.ANY);
        if (this._scope == null) {
            this._scope = Dependent.class;
        }
        if ("".equals(this._name)) {
            this._name = this.getDefaultName();
        }
    }

    protected String getDefaultName() {
        Class<?> targetClass = this.getTargetClass();
        String name = targetClass.isAnnotationPresent(Specializes.class) ? targetClass.getSuperclass().getSimpleName() : targetClass.getSimpleName();
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    protected void bind() {
    }

    @Override
    public boolean isNullable() {
        return !this.getBeanClass().isPrimitive();
    }

    @Override
    public boolean isPassivationCapable() {
        return Serializable.class.isAssignableFrom(this.getTargetClass());
    }

    protected boolean isPassivating() {
        return this._isPassivating || this.isNormalScope() || javax.inject.Singleton.class.equals(this.getScope());
    }

    protected boolean isNormalScope() {
        return this.getBeanManager().isNormalScope(this.getScope());
    }

    public void setPassivating(boolean isPassivating) {
        this._isPassivating = isPassivating;
    }

    @Override
    public T create(CreationalContext<T> env) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void destroy(T instance, CreationalContext<T> env) {
    }

    public void dispose(T instance) {
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return new HashSet<InjectionPoint>();
    }

    protected String getNamedValue(Annotation ann) {
        try {
            if (ann instanceof Named) {
                return ((Named)ann).value();
            }
            Method method = ann.getClass().getMethod("value", new Class[0]);
            method.setAccessible(true);
            return (String)method.invoke((Object)ann, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.log(Level.FINE, e.toString(), e);
            return "";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTargetSimpleName());
        sb.append("[");
        if (this._name != null) {
            sb.append("name=");
            sb.append(this._name);
        }
        for (Annotation qualifier : this._qualifiers) {
            sb.append(",");
            sb.append(qualifier);
        }
        if (this._scope != null && this._scope != Dependent.class) {
            sb.append(", @");
            sb.append(this._scope.getSimpleName());
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        _reservedTypes.add(Closeable.class);
        _reservedTypes.add(Serializable.class);
        _reservedTypes.add(Cloneable.class);
        _reservedTypes.add(Object.class);
        _reservedTypes.add(Comparable.class);
        Method namedValueMethod = null;
        try {
            namedValueMethod = Named.class.getMethod("value", new Class[0]);
            namedValueMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class AnnotationComparator
    implements Comparator<Annotation> {
        AnnotationComparator() {
        }

        @Override
        public int compare(Annotation a, Annotation b) {
            Class<? extends Annotation> annTypeA = a.annotationType();
            Class<? extends Annotation> annTypeB = b.annotationType();
            return annTypeA.getName().compareTo(annTypeB.getName());
        }
    }

    static class MethodNameComparator
    implements Comparator<AnnotatedMethod<?>> {
        MethodNameComparator() {
        }

        @Override
        public int compare(AnnotatedMethod<?> a, AnnotatedMethod<?> b) {
            return a.getJavaMember().getName().compareTo(b.getJavaMember().getName());
        }
    }
}

