/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.FlowProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.loader.Environment;
import com.caucho.xml.QName;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;

public class RecoverableProgram
extends FlowProgram {
    private static final Logger log = Logger.getLogger(RecoverableProgram.class.getName());
    public static final String ATTR = "resin.config.recoverable";
    private ConfigProgram _program;

    public RecoverableProgram(ConfigProgram program) {
        this._program = program;
    }

    @Override
    public QName getQName() {
        return this._program.getQName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void inject(T bean, CreationalContext<T> cxt) throws ConfigException {
        Object oldRecover = Config.getProperty(ATTR);
        try {
            Config.setProperty(ATTR, true);
            this._program.inject(bean, cxt);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.toString(), e);
            Environment.setConfigException(e);
        }
        finally {
            Config.setProperty(ATTR, oldRecover);
        }
    }

    @Override
    public <T> T create(ConfigType<T> type, CreationalContext<T> cxt) throws ConfigException {
        try {
            return this._program.create(type, cxt);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.toString(), e);
            Environment.setConfigException(e);
            return null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._program + "]";
    }
}

