/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.reflect.BaseType;
import com.caucho.inject.Module;
import com.caucho.util.LruCache;
import java.lang.reflect.Type;
import java.util.HashMap;

@Module
public class BaseTypeFactory {
    private LruCache<Type, BaseType> _sourceCache = new LruCache(128);
    private LruCache<Type, BaseType> _targetCache = new LruCache(128);
    private LruCache<Class<?>, BaseType> _classCache = new LruCache(128);

    public BaseType createForSource(Type type) {
        if (type instanceof BaseType) {
            return (BaseType)((Object)type);
        }
        BaseType baseType = this._sourceCache.get(type);
        if (baseType == null) {
            baseType = BaseType.createForSource(type, new HashMap<String, BaseType>(), null);
            if (baseType == null) {
                throw new NullPointerException("unsupported BaseType: " + type + " " + type.getClass());
            }
            this._sourceCache.put(type, baseType);
        }
        return baseType;
    }

    public BaseType createForTarget(Type type) {
        if (type instanceof BaseType) {
            return (BaseType)((Object)type);
        }
        BaseType baseType = this._targetCache.get(type);
        if (baseType == null) {
            baseType = BaseType.createForTarget(type, new HashMap<String, BaseType>(), null);
            if (baseType == null) {
                throw new NullPointerException("unsupported BaseType: " + type + " " + type.getClass());
            }
            this._targetCache.put(type, baseType);
        }
        return baseType;
    }
}

