/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.annotation.NonEL;
import com.caucho.config.attribute.AnnotationAttribute;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.types.AnnotationConfig;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Qualifier;

public class AnnotationInterfaceType<T>
extends ConfigType<T> {
    private static final L10N L = new L10N(AnnotationInterfaceType.class);
    private static final QName TEXT = new QName("#text");
    private final Class<T> _annClass;
    private HashMap<String, Attribute> _attributeMap = new HashMap();

    public AnnotationInterfaceType(Class<T> annClass) {
        this._annClass = annClass;
        for (Method method : annClass.getMethods()) {
            if (method.getParameterTypes().length != 0 || method.getName().equals("annotationType")) continue;
            boolean isEL = !this.isAnnotationPresent(method.getAnnotations(), NonEL.class);
            this._attributeMap.put(method.getName(), new AnnotationAttribute(method.getName(), method.getReturnType(), isEL));
        }
    }

    private boolean isAnnotationPresent(Annotation[] annList, Class<?> annType) {
        for (int i = 0; i < annList.length; ++i) {
            if (!annList[i].annotationType().equals(annType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<T> getType() {
        return this._annClass;
    }

    @Override
    public boolean isQualifier() {
        return this._annClass.isAnnotationPresent(Qualifier.class);
    }

    @Override
    public Object create(Object parent, QName name) {
        return new AnnotationConfig(this, this._annClass);
    }

    @Override
    public Object replaceObject(Object bean) {
        return ((AnnotationConfig)bean).replace();
    }

    @Override
    public Object valueOf(String text) {
        AnnotationConfig ann = new AnnotationConfig(this, this._annClass);
        if (!"".equals(text)) {
            Attribute attr = this.getAttribute(TEXT);
            if (attr == null) {
                throw new ConfigException(L.l("'{0}' does not support value", (Object)this));
            }
            attr.setText(ann, TEXT, text);
        }
        return ann.replace();
    }

    @Override
    public Attribute getAttribute(QName qName) {
        String name = qName.getLocalName();
        if ("#text".equals(name)) {
            name = "value";
        }
        Attribute attr = this._attributeMap.get(name);
        return attr;
    }

    public String toString(HashMap<String, Object> valueMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(this._annClass.getName());
        sb.append("(");
        boolean isFirst = true;
        for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
            if (!isFirst) {
                sb.append(",");
            }
            isFirst = false;
            sb.append(entry.getKey());
            sb.append('=');
            Object value = entry.getValue();
            if (value == null) {
                sb.append(value);
                continue;
            }
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                sb.append("[");
                for (int i = 0; i < values.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(values[i]);
                }
                sb.append("]");
                continue;
            }
            sb.append(value);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._annClass.getName() + "]";
    }
}

