/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.actor2;

import com.caucho.env.actor2.ArrayRing;
import com.caucho.util.L10N;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class ArrayRingAtomic<T>
implements ArrayRing<T> {
    private static final L10N L = new L10N(ArrayRingAtomic.class);
    private final AtomicReferenceArray<T> _ring;
    private final int _length;
    private final int _mask;

    ArrayRingAtomic(int length) {
        this._length = length;
        if (Integer.bitCount(this._length) != 1) {
            throw new IllegalArgumentException(L.l("Invalid ring capacity {0}", (Object)Long.toHexString(this._length)));
        }
        this._ring = new AtomicReferenceArray(this._length);
        this._mask = this._length - 1;
    }

    @Override
    public final int getLength() {
        return this._length;
    }

    @Override
    public final T get(long index) {
        return this._ring.get(this.getIndex(index));
    }

    @Override
    public final void set(long ptr, T value) {
        int index = this.getIndex(ptr);
        this._ring.set(index, value);
    }

    @Override
    public final void setLazy(long index, T value) {
        this._ring.lazySet(this.getIndex(index), value);
    }

    @Override
    public final T takeAndClear(long ptr) {
        T value;
        AtomicReferenceArray<T> ring = this._ring;
        int index = this.getIndex(ptr);
        while ((value = ring.getAndSet(index, null)) == null) {
        }
        return value;
    }

    @Override
    public final void clear(long start, long end) {
        AtomicReferenceArray<T> ring = this._ring;
        while (start < end) {
            ring.lazySet(this.getIndex(start), null);
            ++start;
        }
    }

    @Override
    public final T pollAndClear(long ptr) {
        AtomicReferenceArray<T> ring = this._ring;
        int index = this.getIndex(ptr);
        T value = ring.get(index);
        if (value != null && ring.compareAndSet(index, value, null)) {
            return value;
        }
        return null;
    }

    @Override
    public final int getIndex(long ptr) {
        return (int)(ptr & (long)this._mask);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ring.getClass().getSimpleName() + "," + this.getLength() + "]";
    }
}

