/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread2;

import com.caucho.env.thread2.ThreadLauncher2;
import com.caucho.env.thread2.ThreadPool2;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ResinThread2
extends Thread {
    private static final Logger log = Logger.getLogger(ResinThread2.class.getName());
    private final String _name;
    private final ThreadPool2 _pool;
    private final ThreadLauncher2 _launcher;
    private boolean _isClose;
    private volatile ClassLoader _taskLoader;
    private final AtomicReference<Runnable> _taskRef = new AtomicReference();

    ResinThread2(int id, ThreadPool2 pool, ThreadLauncher2 launcher) {
        this._name = "resin-" + this.getId();
        this._pool = pool;
        this._launcher = launcher;
        this.setDaemon(true);
    }

    public String getDebugName() {
        return this._name;
    }

    public long getThreadId() {
        return this.getId();
    }

    final boolean scheduleTask(Runnable task, ClassLoader loader) {
        if (this._isClose) {
            return false;
        }
        this._taskLoader = loader;
        if (this._taskRef.getAndSet(task) != null) {
            System.out.println("BAD: getandset");
        }
        return true;
    }

    final void close() {
        this._isClose = true;
        LockSupport.unpark(this);
    }

    @Override
    public void run() {
        try {
            this._launcher.onChildIdleBegin();
            this._launcher.onChildThreadLaunchBegin();
            this.runTasks();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._launcher.onChildIdleEnd();
            this._launcher.onChildThreadLaunchEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTasks() {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        ResinThread2 thread = this;
        this.setName(this._name);
        while (!this._isClose) {
            Runnable task = null;
            ClassLoader classLoader = null;
            if (this._taskRef.get() == null) {
                if (this._launcher.isIdleExpire()) {
                    return;
                }
                if (!this._pool.execute(this) || this._taskRef.get() == null) {
                    this.park();
                    if (this._taskRef.get() == null) continue;
                }
            }
            classLoader = this._taskLoader;
            this._taskLoader = null;
            task = this._taskRef.getAndSet(null);
            if (this._isClose) {
                return;
            }
            if (task == null) {
                System.out.println("LAUNCH error: " + this);
                continue;
            }
            try {
                thread.setContextClassLoader(classLoader);
                this._launcher.onChildIdleEnd();
                task.run();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                this._launcher.onChildIdleBegin();
                thread.setContextClassLoader(systemClassLoader);
            }
        }
    }

    void unpark() {
        LockSupport.unpark(this);
    }

    private void park() {
        this.setName(this._name);
        while (!this._isClose && this._taskRef.get() == null) {
            Thread.interrupted();
            LockSupport.park();
        }
    }
}

