/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.AbstractJavaCompiler;
import com.caucho.java.JavaCompileException;
import com.caucho.java.JavaCompilerUtil;
import com.caucho.java.JavacErrorParser;
import com.caucho.java.LineMap;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;

public class EclipseCompiler
extends AbstractJavaCompiler {
    private static boolean _hasCompiler;
    private static final String COMPILER = "org.eclipse.jdt.internal.compiler.batch.Main";
    Process _process;
    String _userPrefix;
    boolean _isDead;

    public EclipseCompiler(JavaCompilerUtil compiler) {
        super(compiler);
    }

    @Override
    protected void compileInt(String[] path, LineMap lineMap) throws IOException, JavaCompileException {
        if (!_hasCompiler) {
            try {
                Class.forName(COMPILER, false, Thread.currentThread().getContextClassLoader());
                _hasCompiler = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JavaCompileException(L.l("Resin can't load org.eclipse.jdt.core.JDTCompilerAdapter.  Usually this means that eclipse-compiler.jar is missing from the classpath.  You can either add eclipse-compiler.jar to the classpath or change the compiler with <java compiler='javac'/>.\n\n{0}", (Object)String.valueOf(e)));
            }
        }
        this.executeInt(path, lineMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInt(String[] path, LineMap lineMap) throws JavaCompileException, IOException {
        MemoryStream tempStream = new MemoryStream();
        WriteStream error = new WriteStream(tempStream);
        try {
            String encoding;
            ArrayList<String> argList = new ArrayList<String>();
            argList.add("-d");
            argList.add(this._compiler.getClassDirName());
            if (this._compiler.getEncoding() != null && (encoding = Encoding.getJavaName(this._compiler.getEncoding())) != null && !encoding.equals("ISO8859_1")) {
                argList.add("-encoding");
                argList.add(this._compiler.getEncoding());
            }
            argList.add("-classpath");
            argList.add(this._compiler.getClassPath());
            ArrayList<String> args = this._compiler.getArgs();
            if (args != null) {
                argList.addAll(args);
            }
            for (int i = 0; i < path.length; ++i) {
                Path javaPath = this._compiler.getSourceDir().lookup(path[i]);
                argList.add(javaPath.getNativePath());
            }
            if (log.isLoggable(Level.FINE)) {
                CharBuffer msg = CharBuffer.allocate();
                msg.append("javac(int)");
                for (int i = 0; i < argList.size(); ++i) {
                    msg.append(" ");
                    msg.append((String)argList.get(i));
                }
                log.fine(msg.close());
            }
            String[] argArray = argList.toArray(new String[argList.size()]);
            int status = -1;
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                EnvironmentClassLoader env = EnvironmentClassLoader.create(ClassLoader.getSystemClassLoader());
                thread.setContextClassLoader(env);
                try {
                    Class<?> cl = Class.forName(COMPILER, false, env);
                    Constructor<?> xtor = cl.getConstructor(PrintWriter.class, PrintWriter.class, Boolean.TYPE);
                    Object value = xtor.newInstance(error.getPrintWriter(), error.getPrintWriter(), Boolean.FALSE);
                    Method compile = cl.getMethod("compile", String[].class);
                    Object result = compile.invoke(value, new Object[]{argArray});
                    status = Boolean.TRUE.equals(result) ? 0 : -1;
                }
                catch (ClassNotFoundException e) {
                    throw new JavaCompileException(L.l("Can't find internal Java compiler.  Either configure an external compiler with <javac> or use a JDK which contains a Java compiler."));
                }
                catch (NoSuchMethodException e) {
                    throw new JavaCompileException(e);
                }
                catch (InstantiationException e) {
                    throw new JavaCompileException(e);
                }
                catch (IllegalAccessException e) {
                    throw new JavaCompileException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IOExceptionWrapper(e);
                }
                error.close();
                tempStream.close();
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
            ReadStream read = tempStream.openReadAndSaveBuffer();
            JavacErrorParser parser = new JavacErrorParser();
            String errors = parser.parseErrors(read, lineMap);
            read.close();
            if (errors != null) {
                errors = errors.trim();
            }
            if (log.isLoggable(Level.FINE)) {
                int ch;
                read = tempStream.openReadAndSaveBuffer();
                CharBuffer cb = new CharBuffer();
                while ((ch = read.read()) >= 0) {
                    cb.append((char)ch);
                }
                read.close();
                log.fine(cb.toString());
            }
            if (status != 0) {
                throw new JavaCompileException(errors);
            }
        }
        finally {
            tempStream.destroy();
        }
    }
}

