/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.MBeanContext;
import com.caucho.jmx.MBeanView;
import com.caucho.jmx.MBeanWrapper;
import com.caucho.loader.Environment;
import com.caucho.loader.WeakCloseListener;
import com.caucho.util.L10N;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MXBean;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.StandardMBean;
import javax.management.loading.ClassLoaderRepository;

public abstract class AbstractMBeanServer
implements MBeanServer {
    private static final L10N L = new L10N(AbstractMBeanServer.class);
    private static final Logger log = Logger.getLogger(AbstractMBeanServer.class.getName());
    static ObjectName SERVER_DELEGATE_NAME;
    private String _defaultDomain;

    public AbstractMBeanServer(String defaultDomain) {
        this._defaultDomain = defaultDomain;
        Environment.addClassLoaderListener(new WeakCloseListener(this));
    }

    protected MBeanContext createContext() {
        return this.createContext(Thread.currentThread().getContextClassLoader());
    }

    protected final MBeanContext getCurrentContext() {
        return this.getCurrentContext(Thread.currentThread().getContextClassLoader());
    }

    protected final MBeanContext getGlobalContext() {
        return this.createContext(ClassLoader.getSystemClassLoader());
    }

    protected abstract MBeanContext createContext(ClassLoader var1);

    protected abstract MBeanContext getCurrentContext(ClassLoader var1);

    protected abstract void setCurrentContext(MBeanContext var1, ClassLoader var2);

    protected abstract MBeanContext getContext(ClassLoader var1);

    protected void removeContext(MBeanContext context, ClassLoader loader) {
    }

    protected MBeanView getView() {
        return this.createContext().getView();
    }

    protected MBeanView getGlobalView() {
        return this.getGlobalContext().getView();
    }

    protected MBeanView getParentView() {
        return null;
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        try {
            Class<?> cl = this.getClassLoaderRepository().loadClass(className);
            return cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e);
        }
        catch (ExceptionInInitializerError e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw new MBeanException((Exception)cause);
            }
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        MBeanWrapper mbean = this.getMBean(loaderName);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(loaderName));
        }
        if (!(mbean.getObject() instanceof ClassLoader)) {
            throw new InstanceNotFoundException(L.l("{0} is not a class loader", (Object)loaderName));
        }
        try {
            ClassLoader loader = (ClassLoader)mbean.getObject();
            Class<?> cl = loader.loadClass(className);
            return cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        try {
            Class<?> cl = this.getClassLoaderRepository().loadClass(className);
            Constructor<?> constructor = this.getConstructor(cl, signature);
            return constructor.newInstance(params);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new MBeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        MBeanWrapper mbean = this.getMBean(loaderName);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(loaderName));
        }
        if (!(mbean.getObject() instanceof ClassLoader)) {
            throw new InstanceNotFoundException(L.l("{0} is not a class loader", (Object)loaderName));
        }
        try {
            ClassLoader loader = (ClassLoader)mbean.getObject();
            Class<?> cl = loader.loadClass(className);
            Constructor<?> constructor = this.getConstructor(cl, signature);
            return constructor.newInstance(params);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new MBeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    private Constructor<?> getConstructor(Class<?> cl, String[] sig) {
        Constructor<?>[] constructors = cl.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (!Modifier.isPublic(constructors[i].getModifiers()) || !this.isMatch(constructors[i].getParameterTypes(), sig)) continue;
            return constructors[i];
        }
        return null;
    }

    private boolean isMatch(Class<?>[] param, String[] sig) {
        if (param.length != sig.length) {
            return false;
        }
        for (int i = 0; i < param.length; ++i) {
            if (param[i].getName().equals(sig[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        return this.registerMBean(this.instantiate(className), name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.registerMBean(this.instantiate(className, loaderName), name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        return this.registerMBean(this.instantiate(className, params, signature), name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.registerMBean(this.instantiate(className, loaderName, params, signature), name);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (object == null) {
            throw new NullPointerException();
        }
        MBeanContext context = this.createContext();
        if (context.getMBean(name) != null) {
            throw new InstanceAlreadyExistsException(L.l("'{0}' in {1}", (Object)name, (Object)context, (Object)this));
        }
        DynamicMBean dynMBean = this.createMBean(object, name);
        if (object instanceof IntrospectionMBean) {
            object = ((IntrospectionMBean)object).getImplementation();
        } else if (object instanceof StandardMBean) {
            object = ((StandardMBean)object).getImplementation();
        }
        MBeanWrapper mbean = new MBeanWrapper(context, name, object, dynMBean);
        return context.registerMBean(mbean, name);
    }

    private DynamicMBean createMBean(Object obj, ObjectName name) throws NotCompliantMBeanException {
        if (obj == null) {
            throw new NotCompliantMBeanException(L.l("{0} mbean is null", (Object)name));
        }
        if (obj instanceof DynamicMBean) {
            return (DynamicMBean)obj;
        }
        Class<?> ifc = this.getMBeanInterface(obj.getClass());
        if (ifc == null) {
            throw new NotCompliantMBeanException(L.l("{0} mbean has no MBean interface for class {1}", (Object)name, (Object)obj.getClass().getName()));
        }
        return new IntrospectionMBean(obj, ifc);
    }

    private Class<?> getMBeanInterface(Class<?> cl) {
        while (cl != null) {
            Class<?>[] interfaces = cl.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> ifc = interfaces[i];
                MXBean mxBean = ifc.getAnnotation(MXBean.class);
                if (!(mxBean != null ? mxBean.value() : ifc.getName().endsWith("MBean") || ifc.getName().endsWith("MXBean"))) continue;
                return ifc;
            }
            cl = cl.getSuperclass();
        }
        return null;
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        MBeanContext context = this.getCurrentContext();
        if (context != null) {
            context.unregisterMBean(name);
            log.finest(name + " unregistered from " + this);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.getObjectInstance();
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        try {
            if (query != null) {
                query.setMBeanServer(this);
            }
            return this.getView().queryMBeans(name, query);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        try {
            if (query != null) {
                query.setMBeanServer(this);
            }
            return this.getView().queryNames(name, query);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        return this.getView().getMBean(name) != null;
    }

    @Override
    public Integer getMBeanCount() {
        return new Integer(this.getView().getMBeanCount());
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.getAttribute(attribute);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.getAttributes(attributes);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        mbean.setAttribute(attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.setAttributes(attributes);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.invoke(operationName, params, signature);
    }

    @Override
    public String getDefaultDomain() {
        return this._defaultDomain;
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        mbean.addNotificationListener(listener, filter, handback);
        this.createContext().addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listenerName, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        MBeanWrapper listenerMBean = this.getMBean(listenerName);
        if (listenerMBean == null) {
            throw new InstanceNotFoundException(String.valueOf(listenerName));
        }
        NotificationListener listener = listenerMBean.getListener();
        if (listener == null) {
            IllegalArgumentException exn = new IllegalArgumentException(L.l("{0} does not implement NotificationListener.", (Object)listenerName));
            throw new RuntimeOperationsException(exn);
        }
        this.addNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        mbean.removeNotificationListener(listener);
        this.createContext().removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listenerName) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanWrapper listenerMBean = this.getMBean(listenerName);
        if (listenerMBean == null) {
            throw new InstanceNotFoundException(String.valueOf(listenerName));
        }
        NotificationListener listener = listenerMBean.getListener();
        if (listener == null) {
            IllegalArgumentException exn = new IllegalArgumentException(L.l("{0} does not implement NotificationListener."));
            throw new RuntimeOperationsException(exn);
        }
        this.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listenerName, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanWrapper listenerMBean = this.getMBean(listenerName);
        if (listenerMBean == null) {
            throw new InstanceNotFoundException(String.valueOf(listenerName));
        }
        NotificationListener listener = listenerMBean.getListener();
        if (listener == null) {
            IllegalArgumentException exn = new IllegalArgumentException(L.l("{0} does not implement NotificationListener."));
            throw new RuntimeOperationsException(exn);
        }
        this.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        this.createContext().removeNotificationListener(name, listener, filter, handback);
        mbean.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        MBeanInfo info = mbean.getMBeanInfo();
        return info;
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        Object obj = mbean.getObject();
        Class<?> cl = obj.getClass();
        return this.isInstanceOf(cl, className);
    }

    private boolean isInstanceOf(Class<?> cl, String className) {
        if (cl == null) {
            return false;
        }
        if (cl.getName().equals(className)) {
            return true;
        }
        if (this.isInstanceOf(cl.getSuperclass(), className)) {
            return true;
        }
        Class<?>[] ifs = cl.getInterfaces();
        for (int i = 0; i < ifs.length; ++i) {
            if (!this.isInstanceOf(ifs[i], className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.getContext().getClassLoader();
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return null;
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.createContext().getClassLoaderRepository();
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException, InstanceNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getDomains() {
        return this.getView().getDomains();
    }

    MBeanWrapper getMBean(ObjectName name) {
        return this.getView().getMBean(name);
    }

    public void destroy() {
        try {
            MBeanServerFactory.releaseMBeanServer(this);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public String toString() {
        if (this._defaultDomain != null) {
            return "MBeanServerImpl[domain=" + this._defaultDomain + "]";
        }
        return "MBeanServerImpl[]";
    }

    static {
        try {
            SERVER_DELEGATE_NAME = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

