/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.module;

import com.caucho.loader.module.ArtifactDependency;
import com.caucho.loader.module.ArtifactVersion;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;

public class Artifact
implements Comparable {
    private static final L10N L = new L10N(Artifact.class);
    private final Path _path;
    private final String _org;
    private final String _module;
    private final String _name;
    private final ArtifactVersion _version;
    private final ArtifactDependency _parent;
    private final ArtifactDependency[] _dependencies;

    public Artifact(Path path, String org, String module, String name, ArtifactVersion version, ArtifactDependency parent, ArrayList<ArtifactDependency> dependencyList) {
        this._path = path;
        this._org = org;
        if (org == null) {
            throw new NullPointerException(L.l("artifact org cannot be null"));
        }
        this._module = module;
        this._name = name;
        if (name == null) {
            throw new NullPointerException(L.l("artifact name cannot be null"));
        }
        this._version = version;
        this._parent = parent;
        this._dependencies = new ArtifactDependency[dependencyList.size()];
        dependencyList.toArray(this._dependencies);
    }

    public Path getPath() {
        return this._path;
    }

    public String getOrg() {
        return this._org;
    }

    public String getName() {
        return this._name;
    }

    public ArtifactVersion getVersion() {
        return this._version;
    }

    public ArtifactDependency getParent() {
        return this._parent;
    }

    public ArtifactDependency[] getDependencies() {
        return this._dependencies;
    }

    public boolean isSameArtifact(Artifact artifact) {
        return this._org.equals(artifact.getOrg()) && this._name.equals(artifact.getName());
    }

    public int compareTo(Object o) {
        if (!(o instanceof Artifact)) {
            return -1;
        }
        Artifact artifact = (Artifact)o;
        if (this._version == null && artifact._version != null) {
            return -1;
        }
        if (artifact._version == null && this._version != null) {
            return 1;
        }
        if (this._version == null && artifact._version == null) {
            return 0;
        }
        return this._version.compareTo(artifact._version);
    }

    public boolean isMatch(ArtifactDependency dependency) {
        if (!dependency.getOrg().equals(this._org)) {
            return false;
        }
        if (!dependency.getName().equals(this._name)) {
            return false;
        }
        return dependency.getVersion() == null || dependency.getVersion().isMatch(this._version);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[org=" + this._org + ",name=" + this._name + ",version=" + this._version + "]";
    }
}

